/***************************************************************
**                                                            **
**  Knihovna pro kontrolu prce s abstraktnmi datovmi typy  **
**  Autor: Pavel abatka                                      **
**  Implementovno v rmci bakalsk prce                   **
**  VUT v Brne, FEKT v ak. roce 2007/2008                     **
**                                                            **
***************************************************************/

/**
** NAVOD K POUZITI:
**	Pro pouziti teto knihovny je treba:
**		- prelozit soubor adtcheck.h zaroven s projektem
**
**		- deklarovat v projektu promennou typu kontrola<Typ_prvek, Typ_data> jmeno_promenne,
**		  kde Typ_prvek je typ uzlu stromu nebo seznamu a Typ_data je typ dat ulozenych
**		  uzlu. Pklad deklarace objektu pro kontrolu:
**				adtcheck<TUzel, int> kont;
**
**		- uzly se registruji pomoci funkce 
**			void registruj(*Uzel, **data, **Ukazatel1, **Ukazatel2, **Ukazatel3).
**		  Prvni parametr funkce je adresa noveho uzlu, druhy je adresa dat. 
**		  Dalsi 1 az 3 parametry jsou adresy ukazatelu na dalsi prvky, tzn.
**		  **Ukazatel2 a **Ukazatel3 NEMUSI BYT ZADANY.
**		  Pklad registrace uzlu:
**				kont.registruj(NovyPtr, &NovyPtr->data, &NovyPtr->Uk_na_dalsi);
**			nebo
**				kont.registruj(NovyPtr, &NovyPtr->data, &NovyPtr->Uk1, &NovyPtr->Uk2);
**
**		- uzly se odebiraji pomoci funkce void odeber(*Uzel);
**		  Pklad odebrani uzlu:
**				kont.odeber(*OdebiranyUzelPtr);
**		  Parametr funkce je adresa odebiraneho prvku.
**
**		- kontrola se provadi pomoci funkce void zkontroluj(void);
**		  Priklad kontroly struktury:
**				kont.zkontroluj();
**		  Na obrazovce se pak objevi i vykreslena struktura nebo chybove hlaseni.
**
**
** PODPOROVANE TYPY:
**	Knihovna umi kontrolovat tyto typy:
**		- jednosmerne vazany linearni seznam
**		- obousmerne vazany linearni seznam
**		- kruhovy seznam
**		- binarni strom
**/



#ifndef __ADTCHECK
#define __ADTCHECK

#define _ZNAKU_MEZI_UZLY_STROMU 5
#define _MAX_DELKA 60

/**
** include knihoven
**/
#include <vector>
#include <iostream>
#include <typeinfo>
#include <string>
#include <list>
#include <cmath>


/**
** Struktura pro uchovani dat
**/
template<class TPrvek, class TData>
	class TSeznam_adr {
		public:
			unsigned int id;
			TPrvek *adresa;
			TData *vypis;
			int pocet_ukazatelu;
		};
template<class TPrvek> 
	class TSeznam_uk {
		public:
			unsigned int id;
			TPrvek **adresa;
		};


/**
** Trida pro kontrolu prace s ADT
**/
template<class TPrvek, class TData>
	class adtcheck {
		private:
			std::vector<TSeznam_adr<TPrvek, TData> > adresy;
			std::vector<TSeznam_uk<TPrvek> > ukazatele;
			int pocet_ukazatelu;
			bool inited;

			unsigned int get_max_id(void) {
				unsigned int ret = 0;
				int j = this->adresy.size();
				for (int i=0; i<j; i++) {
					if (this->adresy[i].id > ret)
						ret = this->adresy[i].id;
					}
				return ret;
				}
			void registruj_ukazatel(unsigned int id, TPrvek **ptr) {
				/**
				** funkce, ktera registruje do this->ukazatele predany ukazatel
				**/
				TSeznam_uk<TPrvek> *pom = new TSeznam_uk<TPrvek>;

				pom->adresa = ptr;
				pom->id = id;
				this->ukazatele.push_back(*pom);
	
				delete pom;
				}
			unsigned int je_reg_adresa (void *ptr) {
				// overi, jestli je adresa prvku jiz registrovana
				int pom = this->adresy.size();
				for (int i=0; i<pom; i++) {
					if ((void *)this->adresy[i].adresa == ptr) {
						return this->adresy[i].id;
						}
					}
				return 0;
				}
			unsigned int je_reg_ukazatel (TPrvek **ptr) {
				// overi, jestli je adresa ukazatele jiz registrovana
				int pom = this->ukazatele.size();
				for (int i=0; i<pom; i++) {
					if (this->ukazatele[i].adresa == ptr)
						return this->ukazatele[i].id;
					}
				return 0;
				}
			void chybove_hlaseni(std::string s, bool ukoncit = false) {
				if (s.length() > 0) {
					this->tisk ("CHYBOVE HLASENI");
					this->tisk ("=============================");
					this->tisk (s);
					std::cin.get();
					}
				if (ukoncit == true) {
					exit(EXIT_FAILURE);
					}
				}
			void vrat_dalsi(unsigned int id_predka, int *dalsi1, int *dalsi2) {
				// vyhleda nasledujici prvky ve strukture
				// vstupni - id prvku
				// vraci   - pole indexu ve vektoru !!!
				unsigned int i = 0, j=0;
				*dalsi1 = -1;
				*dalsi2 = -1;

				for (i = 0; i < this->ukazatele.size(); i++) {	// projdu vsechny ukazatele

										// jestli sedi id, mam adresu naslednika
					if (id_predka == this->ukazatele[i].id) {
						if (*(this->ukazatele[i].adresa) == NULL) {
							if (*dalsi1 == -1) *dalsi1 = -2; // pokud jeste nic neni v dalsim1, zmenim
							else break;						 // jinak koncim, druhy je NULL
							}
						for (j = 0; j < this->adresy.size(); j++) {
										// prochazim adresy a pokud najdu danou, pak vratim index
							if (*(this->ukazatele[i].adresa) == this->adresy[j].adresa) {
								if (*dalsi1 == -1) *dalsi1 = j;
								else *dalsi2 = j;
								break;
								}
							}
						}
					if (*dalsi1 != -1 && *dalsi2 != -1)	// nael jsem oba dva ukazatele, nemusim dal
						break;
					}
				}
			void vrat_predchozi(unsigned int id, int *predchozi) {
				// vyhleda predchozi prvek
				// vstupni - id prvku
				// vraci   - indexu ve vektoru !!!
				unsigned int i = 0, j=0, k = 0;
				*predchozi = -1;

				for (i = 0; i < this->adresy.size(); i++) {	// projdu vsechny adresy

										// jestli sedi id, hledamu ukazatel, ktery na to ukazuje
					if (id == this->adresy[i].id) {
						if (this->adresy[i].adresa == NULL) {
							break;
							}
						for (j = 0; j < this->ukazatele.size(); j++) {
										// prochazim ukazatele a najdu ten, ktery ukazuje na muj
							if (*(this->ukazatele[j].adresa) == this->adresy[i].adresa) {
								k = j;
								for (i = 0; i < this->adresy.size(); i++) {
									if (this->adresy[i].id == this->ukazatele[j].id) {
										*predchozi = i;
										break;
										}
									}
								break;
								}
							}
						}
					if (*predchozi != -1)
						break;
					}
				}
			void vrat_predchozi(unsigned int id, int *predchozi1, int *predchozi2, int *predchozi3) {
				// vyhleda predchozi prvek
				// vstupni - id prvku
				// vraci   - indexy ve vektoru !!!
				unsigned int i = 0, j=0, k = 0;
				*predchozi1 = -1;
				*predchozi2 = -1;
				*predchozi3 = -1;

				for (i = 0; i < this->adresy.size(); i++) {	// projdu vsechny adresy (hledam zadany prvek)

										// jestli sedi id, hledamu ukazatel, ktery na to ukazuje
					if (id == this->adresy[i].id) {
						if (this->adresy[i].adresa == NULL) {
							break;
							}
						for (j = 0; j < this->ukazatele.size(); j++) {
										// prochazim ukazatele a najdu ten, ktery ukazuje na muj
							if (*(this->ukazatele[j].adresa) == this->adresy[i].adresa) {
								k = j;
								for (i = 0; i < this->adresy.size(); i++) {
									if (this->adresy[i].id == this->ukazatele[j].id) {
										// tento ukazatel ukazuje na muj - poznacim si ho
										if (*predchozi1 == -1)
											*predchozi1 = i;
										else if (*predchozi2 == -1)
											*predchozi2 = i;
										else { // predchozil3 = -1
											*predchozi3 = i;
											break;
											}
										}
									}
								break;
								}
							}
						}
					if (*predchozi3 != -1) // jestli uz jsem zaplnil vsechny mista, koncim
						break;
					}
				}
			void vrat_predchozi(unsigned int id, int *predchozi1, int *predchozi2, int *predchozi3, int *predchozi4) {
				// vyhleda predchozi prvek
				// vstupni - id prvku
				// vraci   - indexy ve vektoru !!!
				unsigned int i = 0, j=0, k = 0;
				*predchozi1 = -1;
				*predchozi2 = -1;
				*predchozi3 = -1;
				*predchozi4 = -1;

				for (i = 0; i < this->adresy.size(); i++) {	// projdu vsechny adresy (hledam zadany prvek)

										// jestli sedi id, hledamu ukazatel, ktery na to ukazuje
					if (id == this->adresy[i].id) {
						if (this->adresy[i].adresa == NULL) {
							break;
							}
						for (j = 0; j < this->ukazatele.size(); j++) {
										// prochazim ukazatele a najdu ten, ktery ukazuje na muj
							if (*(this->ukazatele[j].adresa) == this->adresy[i].adresa) {
								k = j;
								for (i = 0; i < this->adresy.size(); i++) {
									if (this->adresy[i].id == this->ukazatele[j].id) {
										// tento ukazatel ukazuje na muj - poznacim si ho
										if (*predchozi1 == -1)
											*predchozi1 = i;
										else if (*predchozi2 == -1)
											*predchozi2 = i;
										else if (*predchozi3 == -1)
											*predchozi3 = i;
										else { // predchozil4 = -1
											*predchozi4 = i;
											break;
											}
										}
									}
								break;
								}
							}
						}
					if (*predchozi4 != -1) // jestli uz jsem zaplnil vsechny mista, koncim
						break;
					}
				}

			void vypis_pameti (void) {
				/**
				** Udela detailni vypis pameti
				**/
				int i=0, j=0, k=0;
				bool nalezeno = false, chyby = false;

				this->tisk ("VYPIS PAMETI"); 
				this->tisk ("--------------------");
				for (i = 0; i < this->adresy.size(); i++) {
					std::cerr << this->adresy[i].id << ")\thodnota: " << *(this->adresy[i].vypis) << 
						",\tadresa: " << this->adresy[i].adresa << std::endl;
					for (j = 0; j < this->ukazatele.size(); j++) {
						if (this->adresy[i].id == this->ukazatele[j].id) {
							if (*(this->ukazatele[j].adresa) == NULL)
								this->tisk ("\t+- Odkaz na prvek: --,\tadresa prvku: NULL");
							else {
								nalezeno = false;
								for (k = 0; k < this->adresy.size(); k++) {
									if (this->adresy[k].adresa == *(this->ukazatele[j].adresa)) {
										nalezeno = true;
										break;
										}
									}
								if (nalezeno == true)
									std::cerr << "\t+- Odkaz na prvek: " << this->adresy[k].id << 
									",\tadresa prvku: " << *(this->ukazatele[j].adresa) << std::endl;
								else {
									this->tisk ("\t+- Odkaz na prvek: CHYBA - neregistrovana adresa v ukazateli");
									chyby = true;
									}
								}	// else ukazatel neni NULL 
							}
						} //for (j = 0; j < this->ukazatele.size(); j++)
					} // for (i = 0; i < this->adresy.size(); i++)
				if (chyby) {
					this->tisk ( "Nektere ukazatele obsahuji spatnou hodnotu. Ukazatel muze obsahovat pouze registrovanou adresu nebo NULL. Pravdepodobna chyba je, ze neni prirazena adrese ukazatele posledniho prvku hodnota NULL.", 0, 1);
					std::cin.get();
					}

				} // void vypis_pameti (void)
			void vypis_poskozene_struktury (void) {
				std::string s;
				int i = 0, j = 0, k = 0;

				this->tisk("Zadana struktura je poskozena a neodpovida zadnemu podporovanemu datovemu typu. Kazdy prvek struktury ma 2 ukazatele, jejich obsah ale neni spravny.", 1);
				this->tisk("V tabulce je prehled prvku a cilu jejcih ukazatelu:", 1);

				this->tisk("PRVEK\t|\tCILE UKAZATELU");
				this->tisk("------------------------------------");

				for (i = 0; i < this->adresy.size(); i++) {
					s.clear();
					s += this->to_string( *(this->adresy[i].vypis) );
					s += "\t|\t";

					for (j = 0; j < this->ukazatele.size(); j++) {
						if (this->adresy[i].id == this->ukazatele[j].id) {
							if (*(this->ukazatele[j].adresa) == NULL)
								s += "NULL\t";
							else {
								for (k = 0; k < this->adresy.size(); k++) {
									if (this->adresy[k].adresa == *(this->ukazatele[j].adresa) ) {
										s += this->to_string( *(this->adresy[k].vypis) );
										s += "\t";
										break;
										}
									}
								}
							}
						}
					s.erase(s.end()-1, s.end());
					this->tisk(s);
					}
				this->tisk("", 1);
				}
			bool spravne_ukazatele (void) {
				/**
				** zkontroluje spravonst ukazatelu v seznamech
				** 1) test pristupu ke vsem prvkum - jestli jiz nebyl uvolnen
				** 2) ukazatele mohou bud obsahovat NULL, nebo adresu 
				**    registrovaneho prvku
				** 3) testuje pocet ukazatelu jednotlivych prvku
				**/
				int i = 0, j = 0;
				bool ok = false, spravne_ukazatele = false;
				std::list<unsigned int> id;
				unsigned int pocet = 0;
				char volba;
				TData pom;

				for (i = 0; i < this->adresy.size(); i++) {
					try {
						*(this->adresy[i].vypis) = *(this->adresy[i].vypis);
					} catch ( char * str ) {
						this->tisk("KRITICKA CHYBA");
						this->tisk("Nektere zaznamy v seznamu obsahuji adresu pameti, ktera neni programu pridelena. Je prevdepodobne, ze nebyla volana metoda ");
						this->tisk("\t\tvoid odeber(TPrvek*)");
						this->tisk("pro vsechny prvky, ktere byly odebrane ze struktury.");
						return false;
					}	// catch (...)
					}
				

				for (i = 0; i < this->ukazatele.size(); i++) {
					ok = false;
					if (*(this->ukazatele[i].adresa) != NULL) {
							// ukazatel neni NULL -> hledam, kam ukazuje
						for (j = 0; j < this->adresy.size(); j++) {
							if (this->adresy[j].adresa == *(this->ukazatele[i].adresa)) {
								ok = true;
								break;
								}
							}
						}
					else	// ukazatel je NULL -> spravne 
						ok = true;
					if (!ok) {
						id.push_back(this->ukazatele[i].id);
						}
					} /* for - pro kazdy ukazatel */

				if (!id.empty()) {
					this->tisk ("Byly nalezeny ukazatele s chybnou hodnotou. Ukazatel muze:");
					this->tisk (" - obsahovat hodnotu NULL");
					this->tisk (" - obsahovat adresu registrovaneho prvku");
					this->tisk ("Nespravne hodnoty mohou zpusobit zavazne chyby programu a jeho pad.", 1);
					this->tisk ("Prvky, v jejichz ukazatelich neni priprazena spravna hodnota:");

					while (!id.empty()) {
						if (id.size() == 1) {
							for (i = 0; i < this->adresy.size(); i++) {
								if (this->adresy[i].id == id.front())
									break;
								}
							this->tisk ( this->to_string ( *(this->adresy[i].vypis) ) );
							}
						else {
							for (i = 0; i < this->adresy.size(); i++) {
								if (this->adresy[i].id == id.front())
									break;
								}
							std::cerr << *(this->adresy[i].vypis) << ", ";
							}
						id.pop_front();
						} /* while - dokud mam prvky */
					spravne_ukazatele = false;
					}
				else {	// ukazatele jsou NULL nebo maji adresu reg. prvku
					spravne_ukazatele = true;
					}

				// kontrola poctu ukazatelu v prvcich
				ok = true; // BOOL, jestli je tato faze ok
				for (i = 0; i < this->adresy.size(); i++) {
					if (pocet == 0) pocet = this->adresy[i].pocet_ukazatelu;
					else if (pocet != this->adresy[i].pocet_ukazatelu) {
						spravne_ukazatele = false;
						ok = false;
						}
					}
				if (!ok) { // jestli je ruzny pocet ukazatelu v prvcich, vypisu chybu
					this->tisk ("Prvky maji ruzny pocet ukazatelu na dalsi. Je zpusobena volanim funkce void registruj () s ruznym poctem parametru pro jednu strukturu.");
					this->tisk ("Prejete si vypis prvku? [Y/N]: ");
					std::cin >> volba;
					if (volba == 'Y' || volba == 'y') {
						for (i = 0; i < this->adresy.size(); i++)
							std::cerr << this->adresy[i].id << ")\tUlozena hodnota: "
							<< *(this->adresy[i].vypis) << ",\t Pocet ukazatelu:"
							<< this->adresy[i].pocet_ukazatelu << std::endl;
						}
					}
				if (spravne_ukazatele)
					return true;
				else
					return false;

				} /* void kontrola (void) */
			inline unsigned int pocet_znaku(TData promenna) {
				std::stringstream ss;
				std::string str;

				ss << promenna;
				str = ss.str();
				return str.length();
				}
			unsigned int hloubka (unsigned int id_root) {
				/**
				** vrati hloubku stromu - od zacatku po root
				**/
				unsigned int max = 0, pom = 0, i = 0, j = 0;

				for (i = 0; i < this->ukazatele.size(); i++) {
					if (this->ukazatele[i].id == id_root) {
						if (*(this->ukazatele[i].adresa) != NULL) {	// pokud ma podstrom, zjistuji jeho hloubku
							for (j = 0; j < this->adresy.size(); j++) {
								if (*(this->ukazatele[i].adresa) == this->adresy[j].adresa) {
									pom = this->hloubka(this->adresy[j].id);	// hledam hloubku podstromu
									if (pom > max)
										max = pom;
									break;
									}
								}
							}
						}
					}
				return max + 1;
				} /* unsigned int hloubka (unsigned int id_root); */
			unsigned int hloubka (unsigned int id_root, unsigned int id_uzel) {
				/**
				** vrati uroven uzlu s danym ID
				**/
				unsigned int max = 0, pom = 0, i = 0, j = 0;

				if (id_root == id_uzel)	// prvek byl nalezen
					return 1;
				else {					// hledam
					for (i = 0; i < this->ukazatele.size(); i++) {
						if (this->ukazatele[i].id == id_root) {			// ukazatel patri rootu ->koukam, co v nem je
							if (*(this->ukazatele[i].adresa) != NULL) { //  ... pokud v nem neni NULL
								for (j = 0; j < this->adresy.size(); j++) {	// hledam prvek, na ktery ukazuje
									if (this->adresy[j].adresa == *(this->ukazatele[i].adresa)) {
										max = this->hloubka(this->adresy[j].id, id_uzel);
										if (max > 0)
											return max + 1;
										}
									}
								}
							}
						}
					}
				return 0;
				} /* unsigned int hloubka (unsigned int id_root, unsigned int id_uzel); */
			bool je_v_seznamu (std::list<unsigned int> *seznam, unsigned int hodnota) {
				/**
				** Overi, jestli je dana hodnota v seznamu
				** Vraci bool
				**/
				if (hodnota < 0)
					return false;

				std::list<unsigned int>::iterator it;

				for (it = (*seznam).begin();  it != (*seznam).end();  ++it) {
					if (*it == hodnota)
						return true;
					}
				return false;
				}
			void zapis_uzel (std::vector<std::string> *pole, unsigned int id_root, std::list<unsigned int> *vypsane_prvky, int level, int x, std::vector<unsigned int> *y) {
				/**
				** zapise do predavaneho pole retezec znaku
				**/
				int i = 0, j = 0, k = 0, pom = 0;
				int z;
				bool prvni = true;

				// najdu si pozici prvku ve vectoru this->adresy
				for (i = 0; i < this->adresy.size(); i++) {
					if (this->adresy[i].id == id_root) break;
					}

				// byl jiz prvek vypsan?
				if (! this->je_v_seznamu(vypsane_prvky, i)) {

					// pokud jeste nebyl prvek vypsn vypisu...
					vypsane_prvky->push_back(i);
					(*pole)[x].replace((*y)[y->size()-level], size_t(this->pocet_znaku(*(this->adresy[i].vypis))), this->to_string(*(this->adresy[i].vypis)));

					// ... hledam id dalsich prvku a volam na ne stejnou funkci,
					//     jestli tam neco je, tak dokreslim sipecky

					prvni = true;
					z = (int) pow ((float)2, (float)level-2);
					for (j = 0; j < this->ukazatele.size(); j++) {
						if (this->ukazatele[j].id == id_root) {
							if (*(this->ukazatele[j].adresa) != NULL) {
								for (k = 0; k < this->adresy.size(); k++) {
									if (this->adresy[k].adresa == *(this->ukazatele[j].adresa)) {
										if (prvni) {
											this->zapis_uzel (pole, this->adresy[k].id, vypsane_prvky, level-1, x-z, y);
											for (pom = (x-z); pom <= x; pom++)
												(*pole)[pom].replace((*y)[(y->size()-level+1)] - 3, size_t(1), "|");
											(*pole)[x].replace((*y)[(y->size()-level+1)] - 4, size_t(2), "-+");
											(*pole)[x-z].replace((*y)[(y->size()-level+1)] - 3, size_t(2), "+-");
											}
										else {
											this->zapis_uzel (pole, this->adresy[k].id, vypsane_prvky, level-1, x+z, y);
											for (pom = x; pom <= x+z; pom++)
												(*pole)[pom].replace((*y)[(y->size()-level+1)] - 3, size_t(1), "|");
											(*pole)[x].replace((*y)[(y->size()-level+1)] - 4, size_t(2), "-+");
											(*pole)[x+z].replace((*y)[(y->size()-level+1)] - 3, size_t(2), "+-");
											}
										}
									}
								}
							prvni = false;
							}
						}
					}

				else {
					// prvek uz byl vypsan - chyba
					(*pole)[x].replace((*y)[y->size()-level], size_t(this->pocet_znaku(*(this->adresy[i].vypis))), this->to_string(*(this->adresy[i].vypis)));
						// oznacim misto, kde je cyklus
					if ((*y)[y->size()-level] > 10)
						(*pole)[x].replace(0, 8, "CYKLUS->");
					else 
						(*pole)[x].replace((*pole)[x].size()-9, 8, "<-CYKLUS");
					} 
				} /* void zapis_uzel(...) */
			std::string to_string (TData data) {
				/**
				** konvertuje cokoliv do stringu
				**/
				std::stringstream ss;
				ss << data;
				return ss.str();
				}
			void strom_levels_y (std::vector<unsigned int> *y, unsigned int id_root, unsigned int levels, unsigned int level_act, int *delka_vypisu) {
				/**
				** vrati vektor y souradnic zacatku levelu
				**/

				unsigned int i = 0, j = 0, pozice_root = 0, pom = 0, znaku_ted, znaku_pred;

				for (pozice_root = 0; pozice_root < this->adresy.size(); pozice_root++) {  // najdu root
					if (this->adresy[pozice_root].id == id_root)
						break;
					}

				if (levels == level_act) { // prvni volani funkce -> inicializace
					for (i = 0; i < levels; i++)
						y->push_back(0);
					}

				znaku_ted = (*y)[levels-level_act] + this->pocet_znaku(*(this->adresy[pozice_root].vypis)) + _ZNAKU_MEZI_UZLY_STROMU;
				if (levels > 1)
					znaku_pred = (*y)[levels-level_act+1];
				else
					znaku_pred = 0;	
				// je-li prvek delsi nez ty pred nim, pak...

				if (znaku_ted > znaku_pred) {
					// ... spocitam rozdil delek...
					i = znaku_ted - znaku_pred;
					// ...a posunu vsechny zacatky dalsich prvku
					pom = levels + 1 - level_act;
					for (j = 0; j < level_act-1; j++)
						(*y)[pom + j] += i;
					}

				// mrknu na dalsi
				if (level_act > 2) {		// pro posledni level to smysl neco hledat
					for (i = 0; i < this->ukazatele.size(); i++) {
						if (this->ukazatele[i].id == id_root && *(this->ukazatele[i].adresa) != NULL) {
							for (j = 0; j < this->adresy.size(); j++) {
								if (this->adresy[j].adresa == *(this->ukazatele[i]).adresa) {
									this->strom_levels_y (y, this->adresy[j].id, levels, level_act-1, delka_vypisu);
									}
								}
							}
						}
					} // if (level_act > 2) {...}


				if (level_act == levels) { // zjistim delku poslednich prvku a vypocitam celkovou
					for (i = 0; i < this->adresy.size(); i++) {
						pom = 1;
						for (j = 0; j < this->ukazatele.size(); j++) {
							if (this->adresy[i].id == this->ukazatele[j].id) {
								if (*(this->ukazatele[j].adresa) != NULL) {
									pom = 0;
									break;
									}
								}
							}
						if (pom == 1 && *delka_vypisu < this->pocet_znaku(*(this->adresy[i].vypis))) {
							*delka_vypisu = this->pocet_znaku(*(this->adresy[i].vypis));

							}
						}

					// vypocitam celkovou delku
					*delka_vypisu += (*y)[levels-1];
					}

				} /* void strom_levels_y */
			void strom_optimalizace_vypisu (std::vector<std::string> *pole) {
				/**
				** Optimalizuje vypisovanou strukturu 
				**    - mazani zbytecnych radku
				**	  - mazani prizpusobeni sirce
				**/
				std::vector<std::string>::iterator i;
				int j = 0;
				bool plny = true;

				// mazani prazdnych radku
				for (i = pole->begin(); i != pole->end(); i++) {

					if (plny) plny = false;
					else i--;

					for (j = 0; j < (*i).size(); j++) {
						if (! ((*i)[j] == ' ' || (*i)[j] == '|')) {
							plny = true;
							break;
							}
						}
					if (! plny)				// mazani prazdneho radku
						pole->erase(i);	
					if (i == pole->end())	// pro posledni radek
						break;
					}

				// prizpusobeni sirce - pokud je to treba
				if ((pole->begin())->size() > _MAX_DELKA) {
					// projdu vsechny sloupce a smazu ty s mezerami
					for (j = 0; j < (pole->begin())->size(); j++) {
						plny = false;
						for (i = pole->begin(); i != pole->end(); ++i) {
							if (! ((*i)[j] == ' ')) {
								plny = true;
								break;
								}
							}
						if (!plny) {
							for (i = pole->begin(); i != pole->end(); ++i)
								(*i).erase((size_t) j, (size_t) 1);
							j--;
							}
						}
					if ((pole->begin())->size() > _MAX_DELKA) {
						// jestlize to stale neni dobre vypisu do danych sloupcu tecky

						plny = true;
						for (i = pole->begin(); i != pole->end(); ++i) {
							plny = false;

							for (j = _MAX_DELKA; j < (*i).size(); j++) {
								if (! ((*i)[j] == ' ')) {
									plny = true;
									break;
									}
								}
							if (plny) {
								(*i).replace(_MAX_DELKA - 4, size_t(3), "...");
								}
							}
						for (i = pole->begin(); i != pole->end(); ++i)
							(*i).erase((*i).begin() + _MAX_DELKA - 1, (*i).end());
						} // if (... > _MAX_DELKA)
					} // if (... > _MAX_DELKA)
				}/* void strom_optimalizace_vypisu () */

			void tisk (std::string s, int mezer_za = 0, int mezer_pred = 0) {
				std::string spom;
				int l = s.size();
				int pom;

				for (pom = 0; pom < mezer_pred; pom++)
					std::cerr << std::endl;

				while (! s.empty()) {
					l = s.size();
					if (l > _MAX_DELKA) {  // delka je vetsi nez povolena
						pom = _MAX_DELKA;
						while (pom > 0) {
							if (s[pom] == ' ')
								break;
							else
								pom--;
							}
						}
					else {
						pom = l;
						}
					spom.assign(s, 0, pom);
					std::cerr << spom << std::endl;
					s.erase((size_t) 0, (size_t) pom+1);
					}
				for (pom = 0; pom < mezer_za; pom++)
					std::cerr << std::endl;
				}
		public:
			adtcheck() {
				if (this->inited != true) { // neni inicializovano
					this->inited = true;
					this->pocet_ukazatelu = 0;
					}
				}
			virtual ~adtcheck() {
				this->adresy.clear();
				this->ukazatele.clear();
				}
			void registruj (TPrvek* ptr, TData *a, TPrvek **Ptr1) {
				void* adr = ptr;

				if (ptr == NULL) {		// snazim se registrovat NULL
					this->chybove_hlaseni("Funkci registruj() se pokousite registrovat nulovy ukazatel. Funkce Registruj musi mit alespon 3 nenulove argumenty.");
					} /**/
				if (je_reg_adresa(adr)) {	// prvek u je v seznamu
					this->chybove_hlaseni("Pokousite se zaregistrovat ukazatel, ktery je jiz zaregistrovan.");
					}						// vede k nedefinovanemu chovani
				else if (ptr != NULL) {		// prvek lze zaregistrovat
					if (this->pocet_ukazatelu == 0)
						this->pocet_ukazatelu = 1;
					else if (this->pocet_ukazatelu != 1) {
						std::string s;
						s = "Funkci registruj predavate jiny pocet parametru nez v predchozich volanich. To muze zpusobovat chyby v programu\n";
						if (a != NULL)
							s += "Chyba vznikla pri registraci prvku s hodnotou " + *a;  
						this->chybove_hlaseni(s);
						}
					TSeznam_adr<TPrvek, TData> *pom = new TSeznam_adr<TPrvek, TData>;
					int new_id = 1 + get_max_id();

					pom->adresa = ptr;
					pom->vypis = a;
					pom->id = new_id;
					pom->pocet_ukazatelu = 1;
					this->adresy.push_back(*pom);
					delete pom;

					registruj_ukazatel(new_id, Ptr1);
					}
				}
			void registruj (TPrvek* ptr, TData *a, TPrvek **Ptr1, TPrvek **Ptr2){
				void* adr = ptr;

				if (ptr == NULL) {		// snazim se registrovat NULL
					this->chybove_hlaseni("Funkci registruj() se pokousite registrovat nulovy ukazatel. Funkce Registruj musi mit alespon 3 nenulove argumenty.");
					} /**/
				if (je_reg_adresa(adr)) {	// prvek u je v seznamu
					this->chybove_hlaseni("Pokousite se zaregistrovat ukazatel, ktery je jiz zaregistrovan.");
					}						// vede k nedefinovanemu chovani
				else if (ptr != NULL) {		// prvek lze zaregistrovat
					if (this->pocet_ukazatelu == 0)
						this->pocet_ukazatelu = 2;
					else if (this->pocet_ukazatelu != 2) {
						std::string s;
						s = "Funkci registruj predavate jiny pocet parametru nez v predchozich volanich. To muze zpusobovat chyby v programu\n";
						if (a != NULL)
							s += "Chyba vznikla pri registraci prvku s hodnotou " + *a;  
						this->chybove_hlaseni(s);
						}
					TSeznam_adr<TPrvek, TData> *pom = new TSeznam_adr<TPrvek, TData>;
					int new_id = 1 + get_max_id();

					pom->adresa = ptr;
					pom->vypis = a;
					pom->id = new_id;
					pom->pocet_ukazatelu = 2;
					this->adresy.push_back(*pom);
					delete pom;

					registruj_ukazatel(new_id, Ptr1);
					registruj_ukazatel(new_id, Ptr2);
					}
				}

			void odeber (TPrvek* ptr) {
				int i = 0, id = -1;
				// najdu zaznam s predanou adresou
				for (i = 0; i < this->adresy.size(); i++) {
					if (this->adresy[i].adresa == ptr) {
						id = this->adresy[i].id;
						this->adresy.erase(this->adresy.begin()+i);
						break;
						}
					}
				// smazu ukazatele s danym ID
				if (id >= 0) {

					for (i = 0; i < this->ukazatele.size(); i++) {
						if (this->ukazatele[i].id == id) {
							this->ukazatele.erase(this->ukazatele.begin()+i);
							i--;
							}
						}
					}
				}
			void zkontroluj (void) {
				this->tisk("KONTROLA", 0, 1);
				this->tisk("======================================", 1);

				#ifdef _ADTCHECK_BPPC
					this->tisk("TESTOVACI PRIKLAD KE KNIHOVNE adtcheck.h", 1);
				#endif

				#ifndef _ADTCHECK_BPPC
					#ifdef _RUN122TRT
						this->tisk("TESTOVACI PRIKLAD KE KNIHOVNE adtcheck.h", 1);
					#endif
				#endif

				unsigned int i=0, j=0, pocet = 0;
				std::list<unsigned int> temp;   // seznam toho, co jsem jeste nepouzil
				std::list<unsigned int> seznam; // posloupnost prvku na vystup
				std::vector<std::string> pole;
				bool prirazen, spravne;
				int dalsi1, dalsi2, predchozi, pom;
				char volba;
				std::vector<unsigned int> strom_y_souradnice;
				std::string s, spom;

				if (this->spravne_ukazatele()) { // test poctu a hodnot ukazatelu v seznamech
					if (this->adresy.empty()) {
						this->chybove_hlaseni("Hlaseni funkce zkontroluj(): nejsou registrovany zadne prvky. Pokracujte stiskem klavesy.");
						}
					else {
					switch (this->pocet_ukazatelu) {
						case 0:
							this->chybove_hlaseni("Volani funkce zkontroluj(): nejsou registrovany zadne prvky");
							break;
						case 1:
							// jedna se o seznam. Postup:

							j = this->ukazatele.size();
							for (i = 0; i < j; i++) {
								temp.push_back(i);
								if (*(this->ukazatele[i].adresa) == NULL)
									pocet++;
								}
								
							if (pocet == 0) {		
								/**
								** jedna se o kruhovy seznam
								**/
								this->tisk ("Struktura odpovida KRUHOVEMU SEZNAMU", 1);
								seznam.push_back( temp.front() );
								temp.pop_front();

								spravne = false;

								for (i = 0; i < this->adresy.size() + 1; i++) {
									prirazen = false;
										// beru nasledovnika a zaradim ho do seznamu
										// beru predchudce a zaradim ho do seznamu
									this->vrat_dalsi(this->adresy[seznam.back()].id, &dalsi1, &dalsi2);
									if (dalsi1 >= 0) {
										if (! this->je_v_seznamu(&seznam, dalsi1)) { // neni v seznamu
											seznam.push_back(dalsi1);
											temp.remove(dalsi1);
											prirazen = true;
											}
										else
											continue;
										}
									if (dalsi2 >= 0) {
										this->chybove_hlaseni("Byl nalezen prvek, ktery ma dva ukazatele");
										}

									if (!prirazen) break;

									for (i = 0; i < this->ukazatele.size(); i++) {
										if (this->ukazatele[i].id == this->adresy[seznam.back()].id)
											break;
										}

									if (this->adresy[seznam.front()].adresa == *(this->ukazatele[i].adresa)) {
										spravne = true;
										break;
										}
									} // for (i = 0; ...)

								// vypis
								s.clear();
								if (!spravne) { // chyba - vypisuji to jako lin. seznam
									this->tisk("Strukturu se nepodarilo sestavit. To je pravdepodobne zpusobeno tim, ze ukazatel posledniho prvku neukazuje na prvni. Z prvku podarilo se rekonstruovat tuto cast, ktera na sebe navazuje:", 1);
									j = seznam.size();
									for (i = 0; i < j; i++) {
										if (seznam.size() == 1) {
											s += this->to_string(*(this->adresy[seznam.front()].vypis));
											}
										else {
											s += this->to_string(*(this->adresy[seznam.front()].vypis));
											s += " -> ";
											seznam.pop_front();
											}
										}
									this->tisk(s);
									}
								else {	// spravne, vypisuji to jako kruhovy seznam
									predchozi = seznam.size();

									for (i = 0; i < predchozi; i++) {
										if (seznam.size() == j) {
											s += this->to_string(*(this->adresy[seznam.front()].vypis));
											seznam.pop_front();
											}
										else {
											s += " -> ";
											s += this->to_string(*(this->adresy[seznam.front()].vypis));
											seznam.pop_front();
											}
										}


									j = 0;								// pocet radku vystupu
									while (! s.empty()) {
										pocet = s.size();
											if (pocet > _MAX_DELKA) {  // delka je vetsi nez povolena
												j++;

												if (j == 1) pom = _MAX_DELKA - 3;
												else        pom = _MAX_DELKA;

												while (pom > 0) {
													if (s[pom] == ' ')
														break;
													else
														pom--;
													}													
												}
											else {
												pom = pocet;
												j++;
												}

											spom.assign(s, 0, pom);
											if (j == 1)      std::cerr << spom << std::endl;
											else if (j == 2) std::cerr << "^  " << spom << std::endl;
											else             std::cerr << "|  " << spom << std::endl;
											s.erase((size_t) 0, (size_t) pom+1);
											}
													// jestli ma vic jak 1 prvek, pak udelam i krouzek
									pom += 3;
									if (j == 1) {
										std::cerr << "^";
										for (i = 0; i < pom - 5; i++)
											std::cerr << " ";
										std::cerr << "|" << std::endl << "+";
										for (i = 0; i < pom - 5; i++)
											std::cerr << "-";
										std::cerr << "+" << std::endl << std::endl;
										}
									else if (j == 2) {
										std::cerr << "|";
										for (i = 0; i < pom - 2; i++)
											std::cerr << " ";
										std::cerr << "|" << std::endl << "+";
										for (i = 0; i < pom - 2; i++)
											std::cerr << "-";
										std::cerr << "+" << std::endl << std::endl;
										}
									else {
										std::cerr << "|";
										for (i = 0; i < pom - 2; i++)
											std::cerr << " ";
										std::cerr << "|" << std::endl << "+";
										for (i = 0; i < pom - 2; i++)
											std::cerr << "-";
										std::cerr << "+" << std::endl << std::endl;
										}
									}

								if (!temp.empty()) {
									this->tisk ("Na nektere registrovane prvky neukazuje zadny ukazatel");
									j = temp.size();
									for (i = 0; i < j; i++) {
										if (temp.size() == 1) {
											s += this->to_string( *(this->adresy[temp.front()].vypis) );
											temp.clear();
											}
										else {
											s += this->to_string( *(this->adresy[temp.front()].vypis) );
											s += ", ";
											temp.pop_front();
											}
										}
									this->tisk(s);
									}
								else
									this->tisk ("Byly vypsany vsechny registrovane prvky, seznam je vytvoren spravne.", 1, 1);
								}



							else if (pocet == 1) {	
									/**
									** linearni seznam
									**/
									
									this->tisk ("Struktura odpovida JEDNOSMERNE VAZANEMU LINEARNIMU SEZNAMU");

									seznam.push_back( temp.front() );
									temp.pop_front();
									for ( i = 0; i < this->adresy.size(); i++ ) {
										prirazen = false;
											// beru nasledovnika a zaradim ho do seznamu
											// beru predchudce a zaradim ho do seznamu
										this->vrat_dalsi(this->adresy[seznam.back()].id, &dalsi1, &dalsi2);
										if (dalsi1 >= 0) {
											if (this->je_v_seznamu(&seznam, dalsi1)) {
												this->tisk("Ve vypise se 1 prvek opakuje - v tomto miste obsahuje cyklus:", 1);
												seznam.push_back(dalsi1);
												temp.remove(dalsi1);
												prirazen = true;
												break;
												}
											else {
												seznam.push_back(dalsi1);
												temp.remove(dalsi1);
												prirazen = true;
												}
											}
										if (dalsi2 >= 0) {
											this->chybove_hlaseni("Byl nalezen prvek, ktery ma dva ukazatele");
											}
										this->vrat_predchozi(this->adresy[seznam.front()].id, &predchozi);
										if (predchozi >= 0) {
											if (this->je_v_seznamu(&seznam, predchozi)) {
												this->tisk("Ve vypise se 1 prvek opakuje - v tomto miste obsahuje cyklus:", 1);
												seznam.push_front(predchozi);
												temp.remove(predchozi);
												prirazen = true;
												break;
												}
											else {
												seznam.push_front(predchozi);
												temp.remove(predchozi);
												prirazen = true;
												}
											}
										if (!prirazen) break;
										if (seznam.front() == seznam.back()) break;
										}

									// vypis dat ulozenych v seznamu
									j = seznam.size();
									this->tisk("", 1);

									for (i = 0; i < j; i++) {
										if (seznam.size() == 1)
											this->tisk ( this->to_string( *(this->adresy[seznam.front()].vypis) ), 1);
										else {
											std::cerr << *(this->adresy[seznam.front()].vypis) << " -> ";
											seznam.pop_front();
											}
										}
									if (!temp.empty()) {
										s.clear();

										this->tisk ("Pomoci ukazatelu v prvcich se neni mozne dostat k nekterym uzlum. Jsou to:", 0, 1);
										j = temp.size();
										for (i = 0; i < j; i++) {
											if (temp.size() == 1)
												s += this->to_string(*(this->adresy[temp.front()].vypis));
											else {
												s += this->to_string(*(this->adresy[temp.front()].vypis)) + ", ";
												temp.pop_front();
												}
											}
										this->tisk(s, 1);
										}
									else
										this->tisk ("Vsechny prvky byly vypsany, seznam je vytvoren spravne.", 1);
									}
								else { // chyba ve strukture - vice nez jeden prvek ma NULL
									this->tisk ("Vice nez jeden prvek obsahuje ukazatel s hodnotou NULL. Nektere ukazatele ukazuji na stejny prvek.", 1);
									break;
									}
								
								
							break;
						case 2:
							/**
							** Jedna se k obousmerne vazany seznam nebo strom
							**    logika: neni strom -> je to seznam
								Promenne:
									unsigned int i=0, j=0, pocet = 0;
									std::list<unsigned int> temp;   // seznam toho, co jsem jeste nepouzil
									std::list<unsigned int> seznam; // posloupnost prvku na vystup
									bool prirazen, spravne;
									int dalsi1, dalsi2, predchozi, pom;
									char volba;
									std::vector<std::string> pole;
							**/


							for (i = 0; i < this->adresy.size(); i++) {
								this->vrat_dalsi(this->adresy[i].id, &dalsi1, &dalsi2);
								if (dalsi1 >= 0) {
									this->vrat_dalsi(this->adresy[dalsi1].id, &predchozi, &pom);
									if (predchozi == i || pom == i)
										temp.push_back(i);
									}
								if (dalsi2 >= 0) {
									this->vrat_dalsi(this->adresy[dalsi2].id, &predchozi, &pom);
									if (predchozi == i || pom == i)
										temp.push_back(i);
									}
								}
								/** v temp jsou ted prvky, ktere maji zpetny ukazatel          ***
								*** ve strome to neni zadny, v obousmerne vaz. seznamu vsechny **/

							if (temp.size() == 0) {
								/**
								** Jedna se o binarni strom
								**/
								temp.clear();
								dalsi1 = 0;

								
								// najdu root
								prirazen = false; // overeni, ze byl nalezen prvek, na ktery jiz dalsi neukazuje
								pom = 0;
								predchozi = 0;
								for (i = 0; i < this->adresy.size(); i++) {
									this->vrat_predchozi(this->adresy[pom].id, &pom);
									if (pom >= 0)
										predchozi = pom;
									else {
										prirazen = true;
										break;
										}
									}

								if (! prirazen) {	// nebyl nalezen root
									this->tisk("Nepodarilo se nalezt prvni prvek, struktura pravdepodobne obsahuje cyklus", 2);
									this->vypis_poskozene_struktury();
									break;
									} /**/

								if (this->adresy.size() > 1)
									this->tisk ("Struktura odpovida BINARNIMU STROMU.", 1);
								else
									this->tisk ("Je zadan pouze jeden prvek, nelze tedy jednoznacne urcit typ struktury. Jedna se pravdepodobne o BINARNI STROM nebo OBOUSMERNE VAZANY LINEARNI SEZNAM.", 1);

								for (i = 0; i < this->adresy.size(); i++)
									temp.push_back(i);						
								// iter. rootu -> predchozi
								// hloubka stromu -> pocet
								// celkova delka vypisu struktury -> dalsi1
								// pocet radku struktury -> dalsi2

								pocet = this->hloubka(this->adresy[predchozi].id);
								dalsi2 = pow (float(2), float(pocet)) - 1;

								this->strom_levels_y(&strom_y_souradnice, this->adresy[predchozi].id, pocet, pocet, &dalsi1);

								temp.clear();

								// inicializace vystupni struktury
								for (i = 0; i < dalsi2; i++) {
									pole.push_back(" ");
									for (j = 1; j < dalsi1; j++)
										pole[i].push_back(' ');
									}


								this->zapis_uzel(&pole, this->adresy[predchozi].id, &temp, pocet, (dalsi2 - 1)/2, &strom_y_souradnice);
								this->strom_optimalizace_vypisu(&pole);


								// vypis
								this->tisk("", 1);
								for (i = 0; i < pole.size(); i++)
									this->tisk(pole[i]);
								this->tisk("", 1);

								if (this->adresy.size() > temp.size()) {	// vypis prvku bez ukazatelu
									s.clear();
									for (i = 0; i < this->adresy.size(); i++) {
										if (! this->je_v_seznamu(&temp, i)) {
											s += this->to_string(*(this->adresy[i].vypis));
											s += ", ";
											}
										}

									s.erase(s.end()-2, s.end());
									this->tisk("CHYBA: nektere prvky nebyly vypsany:");
									this->tisk(s, 1);
									} // vypis prvku bez ukazatelu

								} /* if (temp.size() == 0) binarni strom */



							else if (temp.size() == ((this->adresy.size())*2 - 2)) {
								/**
								** Jedna se o obousmerne vazany LINEARNI SEZNAM
								**/
								temp.clear();
								this->tisk ("Struktura odpovida OBOUSMERNE VAZANEMU LINEARNIMU SEZNAMU.", 1);

								// hledam prvni prvek seznamu
								prirazen = false;
								pom = this->adresy.size();
								for (i = 0; i < pom; i++) {
									this->vrat_dalsi(this->adresy[i].id, &dalsi1, &dalsi2);
									if (dalsi1 < 0) {
										prirazen = true;
										break;
										}
									} // for (i = 0; i < pom; i++)
								predchozi = i; // v predchozi je prvni prvek
								if (!prirazen) {
									this->tisk ("Ve strukture se nepodarilo nalezt prvni prvek. Je mozne, do funkce void registruj() zadavate ukazatele v ruznem poradi.", 1);
									break;
									}

								for (i = 0; i < this->adresy.size(); i++)
									temp.push_back(i);

								for (i = 0; i < this->adresy.size(); i++) {
									this->vrat_dalsi(this->adresy[predchozi].id, &dalsi1, &dalsi2);
									if (temp.size() == 1 || dalsi2 < 0) {		// posledni prvek
										std::cerr << *(this->adresy[predchozi].vypis) << std::endl;
										temp.remove(predchozi);
										break;
										}
									else if (this->je_v_seznamu(&temp, predchozi)) {	// je to v poradku
										std::cerr << *(this->adresy[predchozi].vypis) << " <-> ";
										temp.remove(predchozi);
										}
									else {												// chyba - cyklus
										this->tisk ( this->to_string( *(this->adresy[predchozi].vypis) ));
										this->tisk ("Prvek na konci seznamu jiz byl vypsan drive. Struktura obsahuje cyklus.");
										temp.remove(predchozi);
										break;
										}

									predchozi = dalsi2;
									}

								this->tisk ("", 1);
								if (! temp.empty()) {
									this->tisk ("Nektere nemohly byt vypsany. Jsou to:");
									while (!temp.empty()) {
										if (temp.size() == 1)
											std::cerr << *(this->adresy[temp.front()].vypis) << std::endl;
										else
											std::cerr << *(this->adresy[temp.front()].vypis) << ", ";
										temp.pop_front();
										}
									}

								this->tisk("");
								} /* obousmerne vazany lin. seznam */
							else {
								/**
								** Nejaka uplne jina, nebo poskozena struktura
								**/
								if (temp.size() > 3 && temp.size() > 0.8 * ((this->adresy.size())*2 - 2)) {
									// jedna se pravdepodobne o poskozeny seznam
									this->tisk("poskozeny seznam");
									}
								else if (temp.size() > 3 && temp.size() < 0.2 * ((this->adresy.size())*2 - 2)) {
									this->tisk("poskozeny strom");
									}
								else {
									this->vypis_poskozene_struktury();
									}
								temp.clear();
								break;

							} /* poskozena struktura */

							break;



						default:
							this->chybove_hlaseni("Nedefinovany stav", true);
							break;
						} // switch (this->pocet_ukazatelu)
					} // if (!this->adresy.empty())
				} // if (this->spravne_ukazatele())

				std::cerr << "Prejete si detailni vypis pameti? [Y/N]: ";
				std::cin >> volba;
				if (volba == 'y' || volba == 'Y')
					this->vypis_pameti();
				this->tisk ("======================================", 1, 1);


				// uvolneni promennych
				temp.clear();   // seznam toho, co jsem jeste nepouzil
				seznam.clear(); // posloupnost prvku na vystup
				pole.clear();
				strom_y_souradnice.clear();

				} /* funkce zkontroluj */

		};	/* objekt kontrola<CLASS, CLASS> */



#endif