/*******************************************************************
**                                                                **
**  Knihovna pro kontrolu prce s alokovanou pamt a se soubory  **
**  Autor: Pavel abatka a Pety						              **
**  Implementovno v rmci bakalsk prce                  	  **
**  VUT v Brne, FEKT v ak. roce 2007/2008             	          **
**                                                            	  **
*******************************************************************/

#include "check.h"

#define CHECKER_TRUE 1
#define CHECKER_FALSE 0

#undef malloc
#undef calloc
#undef realloc
#undef free
#undef fopen
#undef fclose
#undef new
#undef delete

/****************************
*      DATOVE TYPY          *
****************************/
typedef enum {EMalloc=1, ECalloc=2, ERealloc=3, ENew=4} alloc_type;

//  prvek seznamu
typedef struct tUnit 
	{
	void* memory_address;	// adresa alokovane pameti
	size_t size;			// alokovana velikost
	char file[__DELKA_NAZVU__];
	char func[__DELKA_NAZVU_FCE__];
	int line;				// radek zdrojoveho kodu (makro __line__)
	int aloc_num;			// abslolutni poradi alokace
	alloc_type type_func;

	struct tUnit *ptr;		// ukazatel na dalsi prvek
	} *tUnitPtr;    //  linearni seznam

typedef struct tList 
	{
	tUnitPtr act;
	tUnitPtr first;
		
	// statistiky programu
	unsigned int count_alloc;
	unsigned int count_free;
	unsigned int size_alloc;
	unsigned int size_free;
	} tList;

typedef struct tUnitFile 
	{
	char file[__DELKA_NAZVU__];		// soubor, ve kterem je volano fopen
	char func[__DELKA_NAZVU_FCE__];	// funkce, ve ktere je volano fopen
	int line;						// radek zdrojoveho kodu (makro __line__)
	char path[__DELKA_NAZVU__];		// jmeno souboru
	char mode[__DELKA_NAZVU_FCE__];	// parametry otevirani souboru
	FILE *memory_address;			// adresa handleru FILE

	struct tUnitFile *ptr;		// ukazatel na dalsi prvek
	} *tUnitFilePtr;

typedef struct tListFile 
	{
	tUnitFilePtr act;
	tUnitFilePtr first;

	// statistiky programu
	unsigned int count_fopen;
	unsigned int count_fclose;
	} tListFile;

/****************************
*          FUNKCE           *
****************************/
//  prace se seznamem - funkce pro kontrolu alokace v C
static void allocc_init_list(tList *L);					// inicializace
static void allocc_insert(tList *, size_t, void*, int, const char[], const char [], alloc_type);	// vlozeni prvku
static void allocc_dispose_act(tList *L);				// zrusi aktualni prvek
static void allocc_set_act(tList *L, void *adress);		// nastavi prvek se zadanou adresou jako aktualni
static void allocc_set_last_act(tList *L);				// nastavi posledni prvek jako aktualni
static int  allocc_active(const tList *L);				// overi, jestli je seznam aktivni

// prace se seznamem - funkce pro kontrolu souboru v C
static void filec_init_list(tListFile *LS);				// inicializace
static void filec_insert(tListFile *, const char [], const char [], int, const char [], const char [], FILE *); // vlozeni prvku
static void filec_dispose_act(tListFile *L);			// zrusi aktualni prvek
static void filec_set_act(tListFile *L, FILE *adress);	// nastavi prvek se zadanou adresou jako aktualni
static void filec_set_last_act(tListFile *L);			// nastavi posledni prvek jako aktualni
static int  filec_active(const tListFile *L);			// overi, jestli je seznam aktivni

// prace se seznamem - pro oba seznamy
static void dispose_lists (tList *, tListFile *);		// zruseni vsech seznamu

// dalsi funkce
static void checkdel(void);								// tuto funkci pridavam do funkce exit
static void program_error(void);						// vyvola chybu, korektne uvolni pamet a soubory, ukonci program
static void print_list(tList *, tListFile*, int, int);	// vypise statistiky programu

/****************************
*  IMPLEMENTACE PROMENNYCH  *
****************************/
static tList L;							// seznam alokovane pameti
static tListFile LF;					// seznam otevrenych souboru
static short int used_alloc =  CHECKER_FALSE;	// bool - byla jiz alokovana nejaka pamet?
static short int used_file_c = CHECKER_FALSE;	// bool - byl jiz otevren nejaky soubor?
static short int corect_exit = CHECKER_TRUE;	// bool - byl program ukoncen bez chyby

/********************************************
*  IMPLEMENTACE FUNKCI  - UZIVATELSKYCH     *
********************************************/
void my_stat(int line, const char soubor[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]) 
	{
	printf("%s: %d :%s\n" ,soubor, line, func);
	// vypise alokovanou pamet a otevrene soubory
	print_list(&L, &LF, CHECKER_TRUE, CHECKER_TRUE);
	}

void my_memory_stat (int line, const char soubor[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]) 
	{
	printf("%s: %d :%s\n" ,soubor, line, func);
	// vypise aktualni stav alokovane pameti
	print_list(&L, &LF, CHECKER_TRUE, CHECKER_FALSE);
	}

void my_file_stat (int line, const char soubor[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]) 
	{
	printf("%s:%d:%s\n" ,soubor, line, func);
	//  vypise aktualni otevrene soubory
	print_list(&L, &LF, CHECKER_FALSE, CHECKER_TRUE);
	}

/***********************************************
*  IMPLEMENTACE ALOKACNI DEALOKACNI FUNKCI - C *
***********************************************/
void* my_malloc(size_t size, int line, const char soubor[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]) 
	{
	void *novyPtr=NULL;
	if (used_alloc == CHECKER_FALSE) 
		{
		used_alloc = CHECKER_TRUE;
		allocc_init_list(&L);
		if (used_file_c == CHECKER_FALSE) atexit(&checkdel);
		}
		
	novyPtr = (void *) malloc (size);

	if (novyPtr != NULL) 
		{
		allocc_insert (&L, size, novyPtr, line, soubor, func, EMalloc);
		L.count_alloc++;
		L.size_alloc=L.size_alloc+size;
		}
	else 
		{
		fprintf(CHECKER_OUT,  "Pri alokaci pameti nastala chyba !\n---------------------------------\nChyba pri volani funkce void* MALLOC (size_t)");
		}
	return novyPtr;
	}

void* my_calloc(size_t count, size_t size, int line, const char soubor[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]) 
	{
	void *novyPtr=NULL;
	if (used_alloc == CHECKER_FALSE) 
		{
		used_alloc = CHECKER_TRUE;
		allocc_init_list(&L);
		if (used_file_c == CHECKER_FALSE) atexit(&checkdel);
		}

	novyPtr = (void *) malloc (count * size);

	if (novyPtr != NULL) 
		{
		allocc_insert (&L, size*count, novyPtr, line, soubor, func, ECalloc);
		L.count_alloc++;
		L.size_alloc=L.size_alloc+(size*count);
		}
	else 
		{
		fprintf(CHECKER_OUT,  "Pri alokaci pameti nastala chyba !\n------------------------------\nChyba pri volani funkce void* CALLOC (size_t, size_t)\n");
		}

	return novyPtr;
	}

void* my_realloc(void* realloc_ptr, size_t size, int line, const char soubor[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]) 
	{
	void *newPtr = NULL;
	if (size < 0) 			// toto je zadany nesmysl
		{
		fprintf(CHECKER_OUT,  "CHECKER:\nChyba - pri volani funkce  void* REALLOC (void *, size_t) byl zadan druhy parametr zaporny\nFunkce nealokovala ani neuvolnila zadnou pamet\n\n");
		}
	else if (size == 0) 		// tzn. jiny zapis funkce free
		{
		allocc_set_act(&L, realloc_ptr);

		if (allocc_active(&L)) 		// uvolnuji korektne pridelenou pamet
			{
			L.count_free++;
			L.size_free += L.act->size;
			allocc_dispose_act(&L);
			free (realloc_ptr);
			}
		else 					// uvolnuji pamet, ktera mi nebyla pridelena
			{
			fprintf(CHECKER_OUT,  "\n\nCHECKER: CHYBA\n------------------------------\n");
			fprintf(CHECKER_OUT,  "Volanim funkce\nvoid realloc (void*, size_t)\nse pokousite uvolnit pamet na adrese: %p, ktera Vam nebyla pridelena.\n", realloc_ptr);
			fprintf(CHECKER_OUT,  "\n-------------------------------------\n");
			fprintf(CHECKER_OUT,  "Lokace chyby:\n");
			fprintf(CHECKER_OUT,  "%i radek zdrojoveho kodu v souboru %s\n", line, soubor);
			fprintf(CHECKER_OUT,  "volani funkce %s\n", func);
			fprintf(CHECKER_OUT,  "celkove %i volani funkce void free(void *) v programu\n", L.count_free+1);
			program_error();
			}
		}  // size == 0
	else 				// budeme pracovat s pameti (alokovat / realokovat)
		{
		if (realloc_ptr == NULL) // tj. jiny zapis funkce malloc
			{
			if (used_alloc == CHECKER_FALSE) 	// jestlize jeste nebylo alokovano
				{
				used_alloc = CHECKER_TRUE;
				allocc_init_list(&L);
				if (used_file_c == CHECKER_FALSE) 
					atexit(&checkdel);
				}
			newPtr = (void *) malloc (size);
			if (newPtr != NULL) 			// 
				{
				allocc_insert (&L, size, newPtr, line, soubor, func, ERealloc);
				L.count_alloc++;
				L.size_alloc=L.size_alloc+size;
				}
			else 
				{
				fprintf(CHECKER_OUT,  "CHECKER: Pri alokaci pameti nastala chyba !\n------------------------------\nChyba pri volani funkce void* REALLOC (void *, size_t,)");
				}
			} // if (realloc_ptr == NULL)
		else 				// volani funkce realloc
			{
			allocc_set_act (&L, realloc_ptr);
			if (!allocc_active(&L)) 
				{
				fprintf(CHECKER_OUT,  "\n\nCHECKER: Chyba - prvni parametr funkce\n void* realloc (void*, size_t) \nzadavate ukazatel na misto v pameti, ktere vam nebylo prideleno ! !\n-----------------------------------------------------\n");
				return NULL;
				}
			newPtr = (void *) realloc (realloc_ptr, size);
			if (newPtr != NULL) 
				{			
				L.size_alloc= (L.size_alloc) - (L.act->size) + (size);
				allocc_dispose_act(&L);
				allocc_insert (&L, size, newPtr, line, soubor, func, ERealloc);
				}
			else 
				{
				fprintf(CHECKER_OUT,  "CHECKER: Pri alokaci pameti nastala chyba !\n------------------------------\nChyba pri volani funkce void* REALLOC (size_t)");
				}
			} // else - if (realloc_ptr != NULL)
		return newPtr;
		} // else - if (size > 0)
	return NULL;
	}

void my_free(void *Ptr, int line, const char soubor[__DELKA_NAZVU__], const char name_fce[__DELKA_NAZVU_FCE__]) 
	{
	allocc_set_act(&L, Ptr);

	if (allocc_active(&L)) {
		if (L.act->type_func == ENew) {
			fprintf(CHECKER_OUT,  "\n\nCHECKER: VAROVANI\nFunkci free uvolnujete pamet, ktera byla alokovana operatorem new. Spravne by mela byt uvolnena operatorem delete.\n\n");
			}
		else {
			L.count_free++;
			L.size_free=L.size_free + L.act->size;
			allocc_dispose_act(&L);
			free(Ptr);
			}
		}
	else {
		fprintf(CHECKER_OUT,  "\n\nCHECKER: CHYBA\n------------------------------\n");
		fprintf(CHECKER_OUT,  "Volanim funkce\nvoid free (void*)\nse pokousite uvolnit pamet na adrese: %p, ktera Vam nebyla pridelena.\n", Ptr);
		fprintf(CHECKER_OUT,  "\n------------------------------\n");
		fprintf(CHECKER_OUT,  "Lokace chyby:\n");
		fprintf(CHECKER_OUT,  "%i radek zdrojoveho kodu v souboru %s\n", line	, soubor);
		fprintf(CHECKER_OUT,  "volani funkce %s\n", name_fce);
		fprintf(CHECKER_OUT,  "celkove %i volani funkce void free(void *) v programu\n", L.count_free+1);
		program_error();
		}
	}


/****************************************************
*  IMPLEMENTACE ALOKACNI DEALOKACNI OPERATORU - C++ *
****************************************************/
#ifdef __cplusplus
void* operator new(size_t size, int line, const char soubor[__DELKA_NAZVU__], const char func[__DELKA_NAZVU__]) /* throw(std::bad_alloc) */
	{	
	void *novyPtr=NULL;
	
	if (used_alloc == CHECKER_FALSE) {
		used_alloc = CHECKER_TRUE;
		allocc_init_list(&L);
		if (used_file_c == CHECKER_FALSE) atexit(&checkdel);
		}
	novyPtr = (void *) malloc(size);
	
	if (novyPtr != NULL) {
		allocc_insert (&L, size, novyPtr, line, soubor, func, ENew);
		L.count_alloc++;
		L.size_alloc=L.size_alloc+size;
		}
	else 
		{
		fprintf(CHECKER_OUT,  "Pri alokaci pameti nastala chyba !\n---------------------------------\nChyba pri alokaci pomoci operatoru void* NEW (size_t)");
		throw std::bad_alloc();
		}
	return novyPtr;
	}

void* operator new[](size_t size, int line, const char soubor[__DELKA_NAZVU__], const char func[__DELKA_NAZVU__]) /* throw(std:bad_alloc) */
	{	
	void *novyPtr=NULL;
	if (used_alloc == CHECKER_FALSE) 
		{
		used_alloc = CHECKER_TRUE;
		allocc_init_list(&L);
		if (used_file_c == CHECKER_FALSE) atexit(&checkdel);
		}

	novyPtr = (void *) malloc(size);
	
	if (novyPtr != NULL) {
		allocc_insert (&L, size, novyPtr, line, soubor, func, ENew);
		L.count_alloc++;
		L.size_alloc=L.size_alloc+size;
		}
	else {
		fprintf(CHECKER_OUT,  "Pri alokaci pameti nastala chyba !\n---------------------------------\nChyba pri alokaci pomoci operatoru void* NEW (size_t)");
		throw std::bad_alloc();
		}
	return novyPtr;
	}

void operator delete (void *Ptr) throw() 
	{
	allocc_set_act(&L, Ptr);

	if (allocc_active(&L)) {
		if (L.act->type_func != ENew) {
			fprintf(CHECKER_OUT,  "\n\nCHECKER: VAROVANI\nOperatorem delete uvolnujete pamet, ktera byla alokovana funkci malloc(). Spravne by mela byt uvolnena funkci free().\n\n");
			}
		else {
			L.count_free++;
			L.size_free=L.size_free + L.act->size;
			allocc_dispose_act(&L);
			free(Ptr);
			}
		}
	}

void operator delete[] (void *Ptr) throw() 
	{
	allocc_set_act(&L, Ptr);

	if (allocc_active(&L)) {
		if (L.act->type_func != ENew) {
			fprintf(CHECKER_OUT,  "\n\nCHECKER: VAROVANI\nOperatorem delete[] uvolnujete pamet, ktera byla alokovana funkci malloc(). Spravne by mela byt uvolnena funkci free().\n\n");
			}
		else {
			L.count_free++;
			L.size_free=L.size_free + L.act->size;
			allocc_dispose_act(&L);
			free(Ptr);
			}
		}
	}

#endif /* __cplusplus */

/***************************************
*  IMPLEMENTACE SOUBOROVYCH FUNKCI - C *
****************************************/
FILE* my_fopen(const char file[__DELKA_NAZVU__], const char mode[__DELKA_NAZVU_FCE__], int line, const char filesource[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]) {
	FILE *novyPtr=NULL;
	if (used_file_c == CHECKER_FALSE) {
		used_file_c = CHECKER_TRUE;
		filec_init_list(&LF);
		if (used_alloc == CHECKER_FALSE) atexit(&checkdel);
		}
		
	novyPtr = fopen(file, mode);

	if (novyPtr != NULL) {
		filec_insert (&LF, file, mode, line, filesource, func, novyPtr);
		LF.count_fopen++;
		}
	else {
		fprintf(CHECKER_OUT,  "CHECKER: CHYBA\nSoubor %s  se nepodarilo otevrit", file);
		}
	return novyPtr;
	}

int my_fclose(FILE* streamPtr, int line, const char file[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]) {
	int succ=0;

	filec_set_act(&LF, streamPtr);

	if (filec_active(&LF)) {
		LF.count_fclose++;
		succ = fclose (streamPtr);
		filec_dispose_act(&LF);
		}
	else {
		fprintf(CHECKER_OUT,  "\n\nCHECKER: CHYBA\n------------------------------\n");
		fprintf(CHECKER_OUT,  "Volanim funkce\nint fclose (FILE*)\nse pokousite uzavrit soubor, ktery nebyl neotevren\n");
		fprintf(CHECKER_OUT,  "\n---------------------------------------\n");
		fprintf(CHECKER_OUT,  "Lokace chyby:\n");
		fprintf(CHECKER_OUT,  "%i radek zdrojoveho kodu v souboru %s\n", line, file);
		fprintf(CHECKER_OUT,  "volani funkce %s\n", func);
		program_error();
		}
	return succ;
	}


/*********************************************************/
/*                  PRACE SE SEZNAMEM                    */
/*********************************************************/

void checkdel (void) {
/*
tato funkce je pridavana do funkce exit
v pripade, ze v programu nenastane fatalni chyba (uvolneni nealokovane pameti apod.),
vypise statistiky programu pomoci print_list() a nasledne uvolni pamet
a uzavre neuzavrene soubory pomoci funkce dispose_list ()
*/
	if (corect_exit == CHECKER_TRUE) print_list(&L, &LF, CHECKER_TRUE, CHECKER_TRUE);
	dispose_lists(&L, &LF);
	}

void allocc_init_list (tList *L) {
// inicializuje seznam
	L->act = NULL;
	L->first = NULL;
	L->count_alloc = 0;
	L->count_free = 0;
	L->size_alloc = 0;
	L->size_free = 0;
	}
void filec_init_list (tListFile *L) {
	// inicializuje seznam
	L->act = NULL;
	L->first = NULL;
	L->count_fopen = 0;
	L->count_fclose = 0;
	}

void allocc_insert (tList *L, size_t size, void* adress, int line, const char file[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__], alloc_type type_func) {  // ok
/*
vlozi na konec seznamu prvek se zadanymi parametry
nastavi vlozeny prvek (tzn. posledni) jako aktualni
*/

	tUnitPtr insPtr;
	char *c=NULL;
	char lomitko= '\\';
		
	insPtr = (tUnitPtr) malloc (sizeof(struct tUnit));

	if (insPtr == NULL) program_error();
	else	
		{
		insPtr->size=size;			// alokovana velikost
		insPtr->line=line;			// radek zdrojoveho kodu (makro __LINE__)
			
		c = strrchr((char *)file, lomitko);		// jmeno souboru (makro __FILE__)
		if (c != NULL) {			// osetreni pro Windows
			strncpy(insPtr->file, (c+1), __DELKA_NAZVU__);	//__FILE__ vraci soubor i s cestou k nemu
			}
		else strncpy(insPtr->file, file, __DELKA_NAZVU__);	// pro Linux/Unix staci nakopirovat

		insPtr->aloc_num=L->count_alloc+1;	// kolikate volani mallocu to je
		insPtr->memory_address=(int*)adress;	// adresa alokovane pameti
		strncpy(insPtr->func, func, __DELKA_NAZVU_FCE__);		// jmeno nadrazene funkce (makro __FUNC__)
		insPtr->type_func=type_func;

		insPtr->ptr = NULL;

		// vlozeni do seznamu
		if (L->first != NULL) 
			{
			allocc_set_last_act(L);
			L->act->ptr = insPtr;
			L->act = insPtr;
			}
		else 
			{
			L->first = insPtr;
			L->act = insPtr;
			}
		}
	}
void filec_insert (tListFile *L, const char soubor[__DELKA_NAZVU__], const char mode[__DELKA_NAZVU_FCE__], int line, const char file[__DELKA_NAZVU__], const char func[__DELKA_NAZVU__], FILE *stream) {  // ok
/*
vlozi na konec seznamu prvek se zadanymi parametry
nastavi vlozeny prvek (tzn. posledni) jako aktualni
*/
	tUnitFilePtr insPtr;
	char *c=NULL;
	char lomitko= '\\';
		
	insPtr = (tUnitFilePtr) malloc (sizeof(struct tUnitFile));

	if (insPtr == NULL) program_error();
	else	
		{
		c = strrchr((char *)file, lomitko);		// jmeno souboru (makro __FILE__)
		if (c != NULL)					// osetreni pro Windows
			strncpy(insPtr->file, (c+1), __DELKA_NAZVU__);	//__FILE__ vraci soubor a cestu k nemu
		else strncpy(insPtr->file, file, __DELKA_NAZVU__);	// pro Linux/Unix staci nakopirovat


		strncpy(insPtr->func, func, __DELKA_NAZVU_FCE__);  // jmeno nadrazene funkce (makro __FUNC__)


		insPtr->line=line;				// radek zdrojoveho kodu (makro __LINE__)

		c = strrchr((char *)soubor, lomitko);		// jmeno otviraneho souboru
		if (c != NULL) strncpy(insPtr->path, (c+1), __DELKA_NAZVU__);
		else strncpy(insPtr->path, soubor, __DELKA_NAZVU__);

		strncpy(insPtr->mode, mode, __DELKA_NAZVU_FCE__);// mod otvirani souboru

		insPtr->memory_address=stream;			   // adresa streamu

		insPtr->ptr = NULL;

		filec_set_last_act(L);			// vlozeni do seznamu
		if (L->act != NULL) 
			{
			L->act->ptr = insPtr;
			L->act = insPtr;
			}
		else 
			{
			L->first = insPtr;
			L->act = insPtr;
			}
		}
	}

void allocc_dispose_act(tList *L) 
	{
/*
zrusi aktivni prvek. 
Vazba z predchoziho se navaze na nasledujici prvek seznamu
nastavi aktivitu na prvni prvek
*/	
	if (allocc_active(L)) {
		if (L->act == L->first) {			// jestli-ze je prvni
			if (L->act->ptr != NULL) L->first=L->first->ptr;
			else L->first = NULL;
			}
		else {						// jestli neni prvni, resim vazby
			tUnitPtr pom;

			pom=L->first;
			while (pom->ptr != L->act) pom=pom->ptr;

			pom->ptr=L->act->ptr;
			}
		free (L->act);
		L->act=L->first;
		}
	}

void filec_dispose_act(tListFile *L) 
	{
/*
zrusi aktivni prvek. 
Vazba z predchoziho se navaze na nasledujici prvek seznamu
nastavi aktivitu na prvni prvek
*/	
	if (filec_active(L)) {
		if (L->act == L->first) {			// jestli-ze je prvni
			if (L->first->ptr != NULL) L->first=L->first->ptr;
			else L->first = NULL;
			}
		else {						// jestli neni prvni, resim vazby
			tUnitFilePtr pom;

			pom=L->first;
			while (pom->ptr != L->act) pom=pom->ptr;

			pom->ptr=L->act->ptr;
			}
		free (L->act);
		L->act=L->first;
		}
	}

void allocc_set_last_act (tList *L) 
	{
/*
nastavi jako aktualni prvek posledni prvek
jestli-ze nastane chyba, nastavi NULL
*/
	if (L->first != NULL) {	
		if (!allocc_active(L)) L->act=L->first;
		while (L->act->ptr != NULL) L->act = L->act->ptr;
		}
	else L->act = NULL;
	}

void filec_set_last_act (tListFile *L) 
	{
/*
nastavi jako aktualni prvek posledni prvek
jestli-ze nastane chyba, nastavi NULL
*/
	if (L->first != NULL) {	
		if (!filec_active(L)) L->act=L->first;
		while (L->act->ptr != NULL) L->act = L->act->ptr;
		}
	else L->act = NULL;
	}

void allocc_set_act (tList *L, void *address) 
	{
/*
najde prvek se zadanou adresou. V pripade, 
ze takovy prvek nenajde, nastavi L->act = NULL
*/	
	L->act=L->first;
	while (L->act!=NULL) {
		if (L->act->memory_address==address) break;
		else L->act=L->act->ptr;
		}
	}

void filec_set_act (tListFile *L, FILE *stream) 
	{
	/*
	najde prvek se zadanou adresou. V pripade, 
	ze takovy prvek nenajde, nastavi L->act = NULL
	*/	
	L->act = L->first;
	while (L->act != NULL) 
		{
		if (L->act->memory_address == stream) break;
		else L->act = L->act->ptr;
		}
	}

int allocc_active(const tList *L)
	{
	/*
	jestli-ze je seznam aktivni, vraci 1, jinak 0
	*/
	if (L->act != NULL) return CHECKER_TRUE;
	return CHECKER_FALSE;
	}
int filec_active (const tListFile *L) 
	{
	/*
	jestli-ze je seznam aktivni, vraci 1, jinak 0
	*/
	if (L->act != NULL) return CHECKER_TRUE;
	return CHECKER_FALSE;
	}

void dispose_lists(tList *L, tListFile *LF) 
	{		
	tUnitPtr pom;
	tUnitFilePtr pomf;

	while (L->first != NULL) 
		{
		pom=L->first;
		L->first=L->first->ptr;
		free(pom->memory_address); 	// uvolnim pamet alokovanou v programu
		free(pom);			// zrusim zaznam ze seznamu
		}
	while (LF->first != NULL) 
		{
		pomf=LF->first;
		LF->first=LF->first->ptr;
		fclose(pomf->memory_address);	// uzavru soubor
		free(pomf);			// zrusim zaznam ze seznamu
		}

	L->first = NULL;
	L->act=NULL;
	LF->first = NULL;
	LF->act=NULL;
	}

void program_error(void) 
	{
	fprintf(CHECKER_OUT,  "\nProgram musel byt ukoncen\n");
	corect_exit = CHECKER_FALSE;
	exit(EXIT_FAILURE);
	}

void print_list(tList *L, tListFile *LF, int print_alloc, int print_file) 
	{
	int a=0, b=0, c=0, d=0, e=0, f=6;
	int __MEZER_MEZI_SLOUPCI__, i=0, x=0;

   fprintf(CHECKER_OUT,  "\n\nCHECKER: KONTROLNI VYPIS \n=======================================================================\n");
   if (print_alloc && used_alloc) {
	fprintf(CHECKER_OUT,  "VYPIS ALOKOVANE PAMETI\n");
	fprintf(CHECKER_OUT,  "Celkovy pocet alokaci pameti v programu: \t%i\n", L->count_alloc);
	fprintf(CHECKER_OUT,  "Celkovy pocet uvolneni pameti v programu: \t%i\n", L->count_free);
	fprintf(CHECKER_OUT,  "Alokovano celkem  %i  bytu, ", L->size_alloc);
	fprintf(CHECKER_OUT,  "uvolneno  %i  bytu\n", L->size_free);
	
	
	if (L->first==NULL) 
		fprintf(CHECKER_OUT,  "Vsechna dynamicka pamet programu byla bez chyby uvolnena. :-)\n\n");
	else 
		{
		fprintf(CHECKER_OUT,  "NEODALOKOVANO ZUSTAVA  %i  BYTU !!!\n\n", L->size_alloc-L->size_free);

		L->act=L->first;			//// ziskam delky nejdelsich udaju ////
		while (L->act != NULL) {				// poradi alokace
			#ifdef __n__
				x = 1 + (int) log10 ((float)L->act->aloc_num);
				if (x>a) a=x;
			#endif
			#ifdef __SOUBOR_RADEK__
				x = strlen (L->act->file);			// soubor
				if (x>b) b=x;
				x = 1 + (int) log10 ((float)L->act->line);	// radek
				if (x>c) c=x;
			#endif
			#ifdef __funkce__
				x = strlen (L->act->func);			// funkce
				if (x>d) d=x;
				if (L->act->type_func == ERealloc) f=7;
				else if (L->act->type_func == ENew) f=3;
				else f=6;
				if (x>f) f=x;
			#endif
			#ifdef __b__
				x = 1 + (int) log10 ((float)L->act->size);	// velikost
				if (x>e) e=x;
			#endif
			L->act = L->act->ptr;
			}
			#ifdef __adresa_pameti__
				i=22;
			#endif

		x = a+b+c+d+e+f+i;				// prizpusobeni sirky tabulky
		if (x<35) __MEZER_MEZI_SLOUPCI__ = 8;
		else if (x<40) __MEZER_MEZI_SLOUPCI__ = 7;
		else if (x<45) __MEZER_MEZI_SLOUPCI__ = 6;
		else if (x<50) __MEZER_MEZI_SLOUPCI__ = 5;
		else if (x<55) __MEZER_MEZI_SLOUPCI__ = 4;
		else if (x<60) __MEZER_MEZI_SLOUPCI__ = 3;
		else __MEZER_MEZI_SLOUPCI__ = 2;
									//////  zahlavi tabulky ////
		fprintf(CHECKER_OUT,  "VYPIS ALOKOVANE PAMETI\n");
		#ifdef __n__
		fprintf(CHECKER_OUT,  "[n]");			// poradi alokace
			if (a < 1) a=1+__MEZER_MEZI_SLOUPCI__;
			else a= a+__MEZER_MEZI_SLOUPCI__;
			for (x=0; x<(a-3); x++) fprintf(CHECKER_OUT,  " ");
		#endif
		#ifdef __SOUBOR_RADEK__
		fprintf(CHECKER_OUT,  "soubor: radek");		// soubor: radek
			if (b+c+2 < 13) b= 13 + __MEZER_MEZI_SLOUPCI__;
			else b = b+c+2+__MEZER_MEZI_SLOUPCI__;
			for (x=0; x<(b-13); x++) fprintf(CHECKER_OUT,  " ");
		#endif
		#ifdef __funkce__
		fprintf(CHECKER_OUT,  "funkce");			// funkce

		if (d > 0){
			d= d+4+f+2+__MEZER_MEZI_SLOUPCI__;
			for (x=0; x<(d-6); x++) fprintf(CHECKER_OUT,  " ");
			}
		else {
			d= f + 2 + __MEZER_MEZI_SLOUPCI__;
			for (x=0; x<(d-6); x++) fprintf(CHECKER_OUT,  " ");
			}
		#endif
		#ifdef __b__
		fprintf(CHECKER_OUT,  "[b]");			// velikost
			if (e < 1) e=1 + __MEZER_MEZI_SLOUPCI__;
			else e= e + __MEZER_MEZI_SLOUPCI__;
			for (x=0; x<(e-3); x++) fprintf(CHECKER_OUT,  " ");
		#endif
		#ifdef __adresa_pameti__
			fprintf(CHECKER_OUT,  "adresa pameti");
		#endif
			fprintf(CHECKER_OUT,  "\n-----------------------------------------------------------------------\n");
								////  telo tabulky ////
		L->act=L->first;
		while (L->act != NULL) {
			#ifdef __n__						// poradi alokace
			fprintf(CHECKER_OUT,  "%i", L->act->aloc_num);
				x=(a-1-(int) log10 ((float)L->act->aloc_num));
				for (i=0; i<x; i++) fprintf(CHECKER_OUT,  " ");
			#endif
			#ifdef __SOUBOR_RADEK__
			fprintf(CHECKER_OUT,  "%s: %i", L->act->file, L->act->line); // file: line
				x= (b- 3 - strlen(L->act->file) - (int) log10 ((float)L->act->line));
				for (i=0; i<x; i++) fprintf(CHECKER_OUT,  " ");
			#endif
			#ifdef __funkce__
			if (strlen(L->act->func)>0) {				// funkce
				fprintf(CHECKER_OUT,  "%s(): ", L->act->func);
				if (L->act->type_func==ERealloc) x = d - 4 - 7 - 2 - strlen(L->act->func);
				else if (L->act->type_func==ENew) x=d- 4 - 3 - 2 - strlen(L->act->func);
				else x = d - 4 - 6 - 2 - strlen(L->act->func);
				}
			else {
				if (L->act->type_func==ERealloc) x= d - 9;
				else if (L->act->type_func==ENew) x= d - 5;
				else x= d - 8;
				}
			if (L->act->type_func==EMalloc)  fprintf(CHECKER_OUT,  "malloc()");
			if (L->act->type_func==ECalloc)  fprintf(CHECKER_OUT,  "calloc()");
			if (L->act->type_func==ERealloc) fprintf(CHECKER_OUT,  "realloc()");
			if (L->act->type_func==ENew)     fprintf(CHECKER_OUT,  "new()");

			for (i=0; i<x; i++) fprintf(CHECKER_OUT,  " ");
			#endif
			#ifdef __b__
			fprintf(CHECKER_OUT, "%i", L->act->size);		// velikost
				x=(e-1-(int) log10 ((float)L->act->size));
				for (i=0; i<x; i++) fprintf(CHECKER_OUT,  " ");
			#endif
			#ifdef __adresa_pameti__
			fprintf(CHECKER_OUT, "%p -> %p", L->act->memory_address, (void*)((char*)L->act->memory_address+L->act->size));
			#endif
			fprintf(CHECKER_OUT, "\n");
			L->act = L->act->ptr;
			}
		fprintf(CHECKER_OUT, "\n");
		}
	}
	else if (print_alloc && !used_alloc) {
		fprintf(CHECKER_OUT, "\nZadna pamet nebyla dynamicky alokovana\n\n");
		}
	if (print_file && used_file_c) {
		if (print_alloc) fprintf(CHECKER_OUT,  "\n-----------------------------------------------------------------------\n");
		fprintf(CHECKER_OUT,  "PREHLED OTEVRENYCH SOUBORU\n");
		fprintf(CHECKER_OUT,  "Pocet otevrenych souboru: \t%i\n", LF->count_fopen);
		fprintf(CHECKER_OUT,  "Pocet uzavrenych souboru: \t%i\n", LF->count_fclose);
		fprintf(CHECKER_OUT,  "NEUZAVRENYCH ZUSTAVA  %i  SOUBORU\n\n",LF->count_fopen-LF->count_fclose);
	
	     if (LF->first==NULL) fprintf(CHECKER_OUT,  "Vsechny soubory byly bez chyby uzavreny\n\n");
	     else {

		LF->act=LF->first;			/* ziskam delky nejdelsich udaju */
		b=0; c=0; d=0; e=0; f=0;

		while (LF->act != NULL) {

			#ifdef __SOUBOR_RADEK__
				x = strlen (LF->act->file);			// soubor se zdrojovym kodem
				if (x>b) b=x;
				x = 1 + (int) log10 ((float)LF->act->line);	// radek
				if (x>c) c=x;
			#endif
			#ifdef __funkce__
				x = strlen (LF->act->func);			// funkce
				if (x>d) d=x;
			#endif
				x = strlen (LF->act->path);			// soubor otvirany
				if (x>e) e=x;
				x = strlen (LF->act->mode);			// mod otevreni
				if (x>f) f=x;


			LF->act = LF->act->ptr;
			} /* while (LF->act != NULL) */

		x = b+c+d+e+f;						// prizpusobeni sirky tabulky
		if (x<25) __MEZER_MEZI_SLOUPCI__ = 8;
		else if (x<30) __MEZER_MEZI_SLOUPCI__ = 7;
		else if (x<35) __MEZER_MEZI_SLOUPCI__ = 6;
		else if (x<40) __MEZER_MEZI_SLOUPCI__ = 5;
		else if (x<45) __MEZER_MEZI_SLOUPCI__ = 4;
		else if (x<50) __MEZER_MEZI_SLOUPCI__ = 3;
		else __MEZER_MEZI_SLOUPCI__ = 2;
									//////  zahlavi tabulky ////
		fprintf(CHECKER_OUT,  "VYPIS OTEVRENYCH SOUBORU\n");

		#ifdef __SOUBOR_RADEK__
		fprintf(CHECKER_OUT,  "Misto otevreni");		// soubor: radek
			if (b+c+2 < 14) b= 14 + __MEZER_MEZI_SLOUPCI__;
			else b = b+c+2+__MEZER_MEZI_SLOUPCI__;
			for (x=0; x<(b-14); x++) fprintf(CHECKER_OUT,  " ");
		#endif
		#ifdef __funkce__
		fprintf(CHECKER_OUT,  "Funkce");			// funkce

		if (d > 0){
			d= d+2+__MEZER_MEZI_SLOUPCI__;
			for (x=0; x<(d-6); x++) fprintf(CHECKER_OUT,  " ");
			}

		#endif
		fprintf(CHECKER_OUT,  "Otevreny soubor");		// soubor: radek
			if (e < 15) e= 15 + __MEZER_MEZI_SLOUPCI__;
			else e = e+__MEZER_MEZI_SLOUPCI__;
			for (x=0; x<(e-15); x++) fprintf(CHECKER_OUT,  " ");
		fprintf(CHECKER_OUT,  "Mod otevreni");		// soubor: radek
			if (f < 12) f= 12 + __MEZER_MEZI_SLOUPCI__;
			else f = f+__MEZER_MEZI_SLOUPCI__;
			for (x=0; x<(f-12); x++) fprintf(CHECKER_OUT,  " ");
		
			fprintf(CHECKER_OUT,  "\n---------------------------------------------------------------------\n");
								////  telo tabulky ////
		LF->act=LF->first;
		while (LF->act != NULL) {
			#ifdef __SOUBOR_RADEK__
			fprintf(CHECKER_OUT,  "%s: %i", LF->act->file, LF->act->line); // file: line
				x= (b- 3 - strlen(LF->act->file) - (int) log10 ((float)LF->act->line));
				for (i=0; i<x; i++) fprintf(CHECKER_OUT,  " ");
			#endif
			#ifdef __funkce__
			if (d > 0) {
				if (strlen(LF->act->func)>0) {				// funkce
					fprintf(CHECKER_OUT,  "%s()", LF->act->func);
					x = d - 2 - strlen(LF->act->func);
					}
				}
			for (i=0; i<x; i++) fprintf(CHECKER_OUT,  " ");
			#endif
			if (strlen(LF->act->path)>0) {				// nazav souboru
				fprintf(CHECKER_OUT,  "%s", LF->act->path);
				x = e - strlen(LF->act->path);
				}
			for (i=0; i<x; i++) fprintf(CHECKER_OUT,  " ");
			if (strlen(LF->act->mode)>0) {				// mod otevreni
				fprintf(CHECKER_OUT,  "%s", LF->act->mode);
				x = f - 2 - strlen(LF->act->mode);
				}
			for (i=0; i<x; i++) fprintf(CHECKER_OUT,  " ");

			fprintf(CHECKER_OUT, "\n");
			LF->act = LF->act->ptr;
			} /* while (LF->act != NULL) */
		fprintf(CHECKER_OUT,  "\n");
		} /* else - nejake soubory jeste nebyly uzavreny */
	} /*if (print_file && used_file_c) */
	fprintf(CHECKER_OUT,  "\n");
   } /* funkce print_list */

/* End of file check.c */
