/*******************************************************************
**                                                                **
**  Knihovna pro kontrolu prce s alokovanou pamt a se soubory  **
**  Autor: Pavel abatka a Pety			                     	  **
**  Implementovno v rmci bakalsk prce                  	  **
**  VUT v Brne, FEKT v ak. roce 2007/2008             	          **
**                                                            	  **
*******************************************************************/

/**
** NAVOD K POUZITI:
**	Pro pouziti teto knihovny je treba:
**	  1)  pripojit soubory check.h a check.c k projektu
**	  2)  pripojit check.h directivou #include. Tj. do 
**		  hlavickoveho souboru uvest
**			#include "check.h"
**
** UZIVATELSKA MAKRA:
**	Jsou definovany 3 uzivatelske makra, ktere lze volat z programu:
**		- void memory_stat(void); - aktualni vypis alokovane pameti
**		- void file_stat(void); - vypis otevrenych souboru v dane chvili
**		- void stat (void); - slucuje obe predchozi funkce
**/

#ifndef __CHECK_H__
#define __CHECK_H__

#define _CRT_SECURE_NO_DEPRECATE 1

/*******************************
*   definice maker pro check   *
*******************************/
// presmerovani vystupu checkeru standardni / chybovy vystup
#define CHECKER_OUT stderr

// delka nazvu funkci a souboru
#define __DELKA_NAZVU__ 50
#define __DELKA_NAZVU_FCE__ 20
// sloupce tabulky vypisu - pri odstraneni definice makra se sloupec nezobrazi
#define __n__
#define __SOUBOR_RADEK__
#define __funkce__
#define __b__
#define __adresa_pameti__ 

// include knihoven
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <stddef.h>
//#include <malloc.h>

#include <errno.h>
#ifdef __cplusplus
	#include <fstream>
	#include <ios>
#endif

#ifndef __STDC_IEC_559__    /* makro __func__  je definovano pouze v C99*/
	#define __func__ ""
#endif /* __STDC_IEC_559__ */


// definice maker pro funkce //
#define malloc(x)     my_malloc((x), __LINE__, __FILE__, __func__)
#define calloc(x, y)  my_calloc((x), (y), __LINE__, __FILE__, __func__)
#define realloc(x, y) my_realloc((x), (y), __LINE__, __FILE__, __func__)
#define free(x)       my_free((x), __LINE__, __FILE__, __func__)
#define fopen(x, y)   my_fopen((x), (y), __LINE__, __FILE__, __func__)
#define fclose(x)     my_fclose((x), __LINE__, __FILE__, __func__)

// uzivatelske makra
// vypise aktualni alokovanou pamet a otevrene soubory
#define stat()        my_stat(__LINE__, __FILE__, __func__)
// vypise aktualni alokovanou pamet
#define memory_stat() my_memory_stat(__LINE__, __FILE__, __func__)
// vypise aktualni otevrene soubory
#define file_stat()   my_file_stat(__LINE__, __FILE__, __func__)

#ifdef __cplusplus
	extern "C" {
#endif /* __cplusplus */

// uzivatelske funkce
 // vypise aktualni alokovanou pamet a otevrene soubory
extern void my_stat(int line, const char soubor[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]);
 // vypise aktualni alokovanou pamet
extern void my_memory_stat(int line, const char soubor[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]);
 // vypise aktualni otevrene soubory
extern void my_file_stat(int line, const char soubor[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]);

//  kontrolni funkce 
extern void* my_malloc(size_t size, int line, const char soubor[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]);
extern void* my_calloc(size_t count, size_t size, int line, const char soubor[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]);
extern void* my_realloc(void* realloc_ptr, size_t size, int line, const char soubor[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]);
extern void my_free(void *Ptr, int line, const char soubor[__DELKA_NAZVU__], const char name_fce[__DELKA_NAZVU_FCE__]);

extern FILE* my_fopen(const char file[__DELKA_NAZVU__], const char mode[__DELKA_NAZVU_FCE__], int line, const char filesource[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]);
extern int my_fclose(FILE* streamPtr, int line, const char file[__DELKA_NAZVU__], const char func[__DELKA_NAZVU_FCE__]);

#ifdef __cplusplus
 }
#endif /* __cplusplus */



/* KONTROLA PAMETI PRO C++ */
#ifdef __cplusplus
 
 // kontrolni operatory	
 extern void* operator new (size_t, int, const char[], const char[]) /* throw(std::bad_alloc) */;
 extern void* operator new[] (size_t, int, const char[], const char[]) /* throw(std::bad_alloc) */;
 extern void operator delete (void *) throw();
 extern void operator delete[] (void *) throw();
	
// definice maker pro operatory
 #define new new (__LINE__, __FILE__, __func__)

#endif /*__cplusplus*/


#endif /* __CHECK_H__ */
