#include "grafy.h"
#include <stdio.h>

void BasicCorr( TPoint *A, TPoint *B)
{
// Uprava souradnic umisteni grafu
// Bod A levy horni bod
// Bod B pravy dolni bod
 int tmp;
 if (B->x < A->x) 
 {
	 tmp = B->x; 
	 B->x = A->x;
	 A->x = tmp;
 }
 if (B->y < A->y) 
 {
	 tmp = B->y; 
	 B->y = A->y;
	 A->y = tmp;
 }

} /* BasicCorr() */

int GetXSteps ( TPoint A, TPoint B)
{
// Vraci optimalni poc. dilku na horiz ose urcenych z bodu A,B
 return(15*(B.x-A.x)/600);
} /* GetXSteps() */

int GetYSteps(TPoint A, TPoint B)
{
// Vraci optimalni poc. dilku na horiz ose urcenych z bodu A,B
 return(15*(B.y-A.y)/500);
} /* GetYSteps() */

void Clear( TPoint A, TPoint B)
{
// Smazani vybrane oblasti
// setfillstyle(SOLID_FILL,BLACK);
// bar(A.x-10,A.y-10,B.x+10,B.y+10);
} /* Clear() */

void VertScale(HDC aHdc, TPoint aA, TPoint aB, float aYLow, float aYHigh, int aYSteps,
                char *aVertLabel)
{
// Vykresleni vertikalni osy vcetne dilku,hodnot a popisky osy

 char str[10];
 int sour,i;
 RECT Rect;

 for (i=0;i<=aYSteps;i++)
  {
   sour = (int)( aB.y - i*(aB.y - aA.y) / (float)aYSteps );
	// sour = (int)( aB.x - i * (aB.y - aA.y) / (float)aYSteps );
   MoveToEx(aHdc, aA.x-4, sour, NULL); 
   LineTo(aHdc, aA.x+4,sour); 
   
   sprintf(str,"%4.1f",(aYLow + i*(aYHigh - aYLow) / aYSteps));
   Rect.left = aA.x-40; Rect.right  = aA.x+40;
   Rect.top  = sour-20; Rect.bottom = sour+20;
   DrawText(aHdc, str, -1, &Rect, DT_SINGLELINE | DT_LEFT | DT_VCENTER) ;

  }
 MoveToEx(aHdc, aA.x, aA.y, NULL);  
 LineTo(aHdc, aA.x,aB.y); 

 Rect.left = aA.x-20; Rect.right  = aA.x+60;
 Rect.top  = aA.y-20; Rect.bottom = aA.y;
 DrawText(aHdc, aVertLabel, -1, &Rect, DT_SINGLELINE | DT_CENTER | DT_VCENTER) ;

} /* VertScale() */

void HorizScale(HDC aHdc, TPoint aA, TPoint aB, float aXLow, float aXHigh, int aXSteps,
                char *aHorizLabel)
{
// Vykresleni horizontalni osy vcetne dilku, hodnot a popisky osy

 char str[10];
 int sour,i;
 RECT Rect;

 for (i=0;i<=aXSteps;i++)
  {
   sour = (int)( aA.x + i* (aB.x - aA.x) / (float)aXSteps );
   MoveToEx(aHdc, sour, aB.y-4, NULL);  
   LineTo(aHdc, sour,aB.y+4); 

   sprintf(str,"%-4.1f",(aXLow+i*(aXHigh-aXLow)/aXSteps));
   Rect.left = sour - 20; Rect.right = sour + 20;
   Rect.top = aB.y + 10; Rect.bottom = aB.y + 20;
   DrawText(aHdc, str, -1, &Rect, DT_SINGLELINE | DT_RIGHT | DT_VCENTER) ;
  }
 MoveToEx(aHdc, aA.x, aB.y, NULL);  
 LineTo(aHdc, aB.x,aB.y); 

 Rect.left = aB.x+5; Rect.right = aB.x+40;
 Rect.top = aB.y-25;  Rect.bottom = aB.y+20;
 DrawText(aHdc, aHorizLabel, -1, &Rect, DT_SINGLELINE | DT_LEFT | DT_VCENTER) ;
 //outtextxy(B.x-5,B.y+20,HorizLabel);

} /* HorizScale() */

void GrafNet(HDC aHdc, TPoint aA, TPoint aB, int aXSteps, int aYSteps)
{
 HPEN hpen, hpenOld;
 int sour,i;

 // Nakresli cerchovanou carou, sedou barvou po krocich XSteps a YSteps
 hpen = CreatePen(PS_DOT, 1, RGB(0x00, 0x00, 0xFF));
 hpenOld = SelectObject(aHdc, hpen);

// Vykresleni site rastrovacich car
 for (i=0; i<=aXSteps; i++)
  {
   sour = (int)( aA.x + i*(aB.x - aA.x) / (float)aXSteps );
   MoveToEx(aHdc, sour, aA.y, NULL); 
   LineTo(aHdc,sour,aB.y); 
  }

 for (i=0; i<=aYSteps; i++)
  {
   sour = (int)( aA.y + i*(aB.y - aA.y) / (float)aYSteps );
   MoveToEx(aHdc, aA.x, sour, NULL); 
   LineTo(aHdc,aB.x,sour);
  }
 SelectObject(aHdc, hpenOld);
 DeleteObject(hpen);
} /* GrafNet() */


void AnaDraw( HDC aHdc, TData aData, int aNum, TPoint aA, TPoint aB, float aYLow,
              float aYHigh, COLORREF aColor)
{
// Nakresleni grafu prubehu analog zavislosti

 HPEN hpen, hpenOld;
 int x1,i;
 float Ykoef=(aB.y-aA.y)/(aYHigh-aYLow);

 hpen = CreatePen(PS_SOLID, 3, aColor);
 hpenOld = SelectObject(aHdc, hpen);

 MoveToEx(aHdc, aA.x,(int)(aB.y-(aData[0]-aYLow)*Ykoef), NULL); 

 for (i=0;i<aNum;i++)
  {
   x1=(int)(aA.x + i*(aB.x - aA.x) / (float)(aNum));
   //lineto(x1,B.y-(Data[i]-YLow)*Ykoef);
   LineTo(aHdc,x1,(int)(aB.y-(aData[i]-aYLow)*Ykoef) );
  }

 SelectObject(aHdc, hpenOld);
 DeleteObject(hpen);
} /* AnaDraw() */

float Min( TData aData, int aNum)
{
// Vraci minimum z pole Data o velikosti Num
 int i;
 float tmp = aData[0];

 for (i=0; i<aNum; i++) 
	 if(aData[i] < tmp) tmp = aData[i];
 return(tmp);
} /* Min() */

float Max( TData aData, int aNum)
{
// Vraci maximum z pole Data o velikosti Num
 int i;
 float tmp = aData[0];
 for (i=0; i<aNum; i++) 
	 if(aData[i] > tmp) tmp = aData[i];
 return(tmp);
} /* Max() */
