// Header soubor pro modul grafy.c      (c) Pety 1998,2003

#ifndef _GRAFY_H_     // Jestlize jeste nebylo definovano tak definuj.
#define _GRAFY_H_

#include <windows.h>

#define MAXDATA 50

typedef float TData[MAXDATA];     // Deklarace typu pole hodnot pro kresleni

typedef struct                  // deklarace struktury (recordu) TPoint
        {
         int x,y;
        } TPoint;

void BasicCorr ( TPoint *A, TPoint *B);
                                // Uprava souradnic umisteni grafu
int GetXSteps ( TPoint A, TPoint B);
                                // Optimalni poc. dilku na horiz ose
int GetYSteps ( TPoint A, TPoint B);
                                // Optimalni poc. dilku na horiz ose
void Clear( TPoint A, TPoint B);
                                // Smazani vybrane oblasti
void VertScale(HDC aHdc, TPoint aA, TPoint aB, float aYLow, float aYHigh, int aYSteps,
                char *aVertLabel);
                                // Vykresleni vertikalni osy vcetne hodnot
                                // a popisu osy
void HorizScale(HDC aHdc, TPoint aA, TPoint aB, float aXLow, float aXHigh, int aXSteps,
                char *aHorizLabel);
                                // Vykresleni horizontalni osy vcetne hodnot
                                // a popisu osy
void GrafNet(HDC aHdc, TPoint aA, TPoint aB, int aXSteps, int aYSteps);
                                // Vykresleni site rastrovacich car

void AnaDraw( HDC aHdc, TData aData, int aNum, TPoint aA, TPoint aB, float aYLow,
              float aYHigh, COLORREF aColor);
                                // Nakresleni grafu prubehu analog zavislosti
float Min ( TData Data, int Num); // Vraci minimum z pole o velikosti Num
float Max ( TData Data, int Num); // Vraci maximum z pole o velikosti Num

#endif /* _GRAFY_H_ */


