/** \file CBNode_TWeekDay.cpp
 *  \brief CBNode_TWeekDay class source
 *  \details File contains implementation of CBNode_TWeekDay support functions and global operators also for \c enum TWeekDay
 *  \warning Don't modify this file
 *	\author Pety 2012
 *	$Id: CBNode_TWeekDay.cpp 1 2012-10-15 13:25:08Z petyovsky $
 */

#include <cstring>
#include "CBNode_TWeekDay.h"

namespace CBNode_TWeekDay
	{
	// Definition of the TWeekDay support constants
	static const unsigned KTWeekDaysCount = 7;	///< Numbers of day in the week
	static const unsigned KTWeekDaysNameMaxLength = 10; ///< Max length of day name
	static const char* const KTWeekDaysName[KTWeekDaysCount] =
	{"Monday)", "Tuesday)", "Wednesday)", "Thursday)", "Friday)", "Saturday)", "Sunday)"}; ///< Day name definition
	
	TWeekDay CheckingRangeWithException(const unsigned aDayNum)
		{
		if(aDayNum > unsigned(ESunday)) 
			{
			std::ostringstream oss; oss << "Value: " << aDayNum << " is out of range for type enum TWeekDay!";
			throw std::range_error(oss.str());
			}
		return(TWeekDay(aDayNum));
		} /* CheckingRangeWithException() */
	
	std::ostream& operator<<(std::ostream& aOStream, const TWeekDay& aWeekDay)
		{
		aOStream << '(' << KTWeekDaysName[unsigned(aWeekDay)]; 
		return(aOStream);
		} /* operator<<() */

	std::istream& operator>>(std::istream& aIStream, TWeekDay& aWeekDay)
		{		
		char ch[KTWeekDaysNameMaxLength + 1];
		unsigned i = 0, daynum = 0;
		do
			aIStream >> ch[0];
		while(ch[0] != '(');
		do
			aIStream >> ch[i];
		while( (ch[i++] != ')') && (i < KTWeekDaysNameMaxLength) );
		ch[i] = '\0';

		for(; (daynum < KTWeekDaysCount) && (std::strncmp(ch, KTWeekDaysName[daynum], KTWeekDaysNameMaxLength)); daynum++) ;
		aWeekDay = CheckingRangeWithException(daynum);
		return(aIStream);
		} /* operator>>() */

	} /* namespace CBNode_TWeekDay */
