/** \file main.cpp
 *  \brief Main source
 *  \details Simple CBNode example of usage
 *	\author Pety 2012
 *	$Id: main.cpp 1 2012-10-15 13:25:08Z petyovsky $
 */

#include <iostream>
#include "CBNode.h"
#include "check.h"

using std::endl;
using std::cout;
using std::cin;
using std::cerr;

int main(int argc, char *argv[])
	{
	cout << "Pocet parametru: " << argc << endl;
	for(int i = 0; i < argc; i++)
		cout << "Parametr #" << i << ": " << argv[i] << endl;
	
	cout << endl << "Nyni existuje " << CBNode::Living() << " instanci tridy: " << DM(typeid(CBNode).name()) << endl;
	try
		{	
	// Test c'tor implicitni
		CBNode a;
		cout << "Objekt a je " << a.Index() << "-tou instanci tridy: " << DM(typeid(CBNode).name()) << endl;
		cout << "Nyni existuje " << CBNode::Living() << " instanci tridy: " << DM(typeid(CBNode).name()) << endl;
		cout << "V prubehu programu zatim vzniklo celkem " << CBNode::Total() << " instanci tridy: " << DM(typeid(CBNode).name()) << endl;
	// Test c'tor konverzni
		CBNode b(CBNode::TestValue0());
		CBNode c(CBNode::TestValue1());
	// Test c'tor copy
		CBNode d = a;
		CBNode e(a);
	// Test c'tor se dvema parametry
		CBNode f(CBNode::TestValue0(), &d, &e);
	// Test c'tor z retezce
			const char *bagr(CBNode::TestStringValue1());
		CBNode g(CBNode::TestStringValue0());
		CBNode h(CBNode::TestStringValue1(), &g, &g);
			cout << *bagr;
	// Test CBNode::operator<<
		cout << "CBNode::operator>>" << endl;
		cout << ' ' << a << ',' << b << ',' << c << endl;
	// Test CBNode::operator>>
		cout << "CBNode::operator<<" << endl;
		cout << " Zadej " << DM(typeid(CBNode).name()) << " hodnotu: ";
		cin >> d;
		cout << " Zadal jsi hodnotu: " << d << endl;
	// Test setter CBNode::SetValue
		cout << "CBNode::SetValue" << endl;
		b.SetValue(CBNode::TestValue0());
	// Test getter CBNode::Value
		cout << "CBNode::Value" << endl;
		cout << " Value=" << a.Value() << endl;
	// Test setter/getter CBNode::ExtraInt
	// Pouzitelne pouze pro nektere projekty, napr. multimnozina, prioritni fronta. V ostatnich projektech nebude vyuzito.
		int priority = 1;
		a.SetExtraInt(priority);
		priority = a.ExtraInt();
		int pocetStejnychPrvkuMultimnoziny = 1;
		a.SetExtraInt(pocetStejnychPrvkuMultimnoziny);
		pocetStejnychPrvkuMultimnoziny = a.ExtraInt();
	// Test CBNode::operator-
		cout << "CBNode::operator-" << endl;
		cout << ' ' << c << ',';
		cout << -c << ',';
		cout << c << endl;
    // Test CBNode::operator=
		c = a;
	// Test CBNode::operator==
		cout << "CBNode::operator==" << endl;
		cout << " Hodnota v objektu a je ";
		if(a == d)
			cout << "stejna jako hodnota";
		else
			cout << "ruzna od hodnoty";
		cout << " v objektu d" << endl;
	// Test CBNode::operator!=
		cout << "CBNode::operator!=" << endl;
		cout << " Hodnota v objektu a je ";
		if(a != d)
			cout << "ruzna od hodnoty";
		else
			cout << "stejna jako hodnota";
		cout << " v objektu d" << endl;
	// Test CBNode::operator>
		cout << "CBNode::operator>" << endl;
		cout << " Hodnota v objektu a ";
		if(a > d)
			cout << "je";
		else
			cout << "neni";
		cout << " vetsi nez hodnota v objektu d" << endl;
	// Test CBNode::operator<
		cout << "CBNode::operator<" << endl;
		cout << " Hodnota v objektu a ";
		if(a < d)
			cout << "je";
		else
			cout << "neni";
		cout << " mensi nez hodnota v objektu d" << endl;
		cout << "Nyni existuje " << CBNode::Living() << " instanci tridy: " << DM(typeid(CBNode).name()) << endl;
			
	// Test getter CBNode::Left()
		cout << "CBNode::Left" << endl;
		cout << " Hodnota ukazatele Left v objektu a " << a.Left() << endl;
		cout << "  (Objekt a je na adrese: " << &a << ')' << endl;
	// Test getter CBNode::Right()
		cout << "CBNode::Right" << endl;
		cout << " Hodnota ukazatele Right v objektu a " << a.Right() << endl;
		cout << "  (Objekt a je na adrese: " << &a << ')' << endl;
	// Test setter CBNode::SetNext
		cout << "CBNode::SetLeftRight" << endl;
		cout << " Propojeni obousmerne vazaneho kruhoveho seznamu objektu a-h" << endl;
		a.SetLeftRight(&h, &b);
		b.SetLeftRight(&a, &c);
		c.SetLeftRight(&b, &d);
		d.SetLeftRight(&c, &e);
		e.SetLeftRight(&d, &f);
		f.SetLeftRight(&e, &g);
		g.SetLeftRight(&f, &h);
		h.SetLeftRight(&g, &a);
	// Test getter CBNode::Next()
		cout << "CBNode::Left" << endl;
		cout << " Hodnota ukazatele Left v objektu a " << a.Left() << endl;
		cout << "  (Objekt h je na adrese: " << &h << ')' << endl;
		cout << "CBNode::Right" << endl;
		cout << " Hodnota ukazatele Right v objektu a " << a.Right() << endl;
		cout << "  (Objekt b je na adrese: " << &b << ')' << endl;
	// Test nemoznosti odkazovat na NULL/nuulptr
		//a.SetLeft(NULL);
		//a.SetRight(NULL);
	// Vytisknuti a rozpojeni seznamu instanci tridy CBNode
		cout << "Vytisknuti a rozpojeni seznamu instanci tridy: " << DM(typeid(CBNode).name()) << endl;
		CBNode *ptrAkt = &a;
		do
			{
			cout << '\t' << ptrAkt << ": " << DM(typeid(*ptrAkt).name()) << "#" << ptrAkt->Index() << " <" << ptrAkt->Left() << ',' << ptrAkt->Value() << ',' << ptrAkt->Right() << '>' << endl;
			ptrAkt = dynamic_cast<CBNode*> (ptrAkt->Right());
			}
		while(ptrAkt != &a);
			
		do
			{
			ptrAkt->Left()->SetRight(ptrAkt->Right());
			ptrAkt->Right()->SetLeft(ptrAkt->Left());
			
			ptrAkt->SetLeft(ptrAkt);
			ptrAkt = dynamic_cast<CBNode*> (ptrAkt->SetRight(ptrAkt));
			}
		while(ptrAkt != ptrAkt->Left());
		} /* try */
	
	catch(std::range_error &e)
		{
		cerr << "std::range_error: " << e.what() << "!!!\n\a" << endl;
		}
	catch(std::runtime_error &e)
		{
		cerr << "std::runtime_error: " << e.what() << "!!!\n\a" << endl;
		}

// Doplnkove testy
#ifdef SUPPLEMENT_TESTS_TWEEKDAY
	try 
		{
		unsigned x = 0;
		CBNode a;
		cout << "CBNode::operator<<" << endl;
		cout << " Zadej schvalne (kvuli testovani) cislo vetsi nez (0-6) jako hodnotu dne: ";
		cin >> x;
		a.SetValue(TWeekDay(x));
		cout << " Zadal jsi hodnotu: " << a << endl;

		cout << " Zadej schvalne spatne jmeno dne(napr. (Wonday)): ";
		cin >> a;
		cout << " Zadal jsi hodnotu: " << a << endl;
		}
	catch(std::range_error &e)
		{
		cerr << "std::range_error: " << e.what() << "!!!\n\a" << endl;
		}
	catch(std::runtime_error &e)
		{
		cerr << "std::runtime_error: " << e.what() << "!!!\n\a" << endl;
		}
#endif
	cout << "Nyni existuje " << CBNode::Living() << " instanci tridy: " << DM(typeid(CBNode).name()) << endl;
	cout << "V prubehu programu vzniklo celkem " << CBNode::Total() << " instanci tridy: " << DM(typeid(CBNode).name()) << endl;
	return(0);
	}
