#ifndef __CXITEM_TWEEKDAY_H__
#define __CXITEM_TWEEKDAY_H__
/** \file CXItem_TWeekDay.h
 *  \brief CXItem_TWeekDay class header
 *  \details File contain CXItem_TWeekDay::CXItem definition.
 *  \warning Don't modify this file
 *  \author Pety 2014
 *  $Id: CXItem_TWeekDay.h 112 2014-11-01 19:02:33Z petyovsky $
 */

#include "CXItemBase.h"
#include "check.h"

/** \brief Namespace for encapsulating of \c TWeekDay variant of CXItem class
 *  \details For selecting this variant of CXItem class uncomment \c using \c namespace section in the CXItem.h
 */
namespace CXItem_TWeekDay
	{
	/** \brief Basic definition of enumeration type for representing day of week.
	*/
	enum TWeekDay
		{EMonday = 0, ETuesday, EWednesday, EThursday, EFriday, ESaturday, ESunday};

	enum { KTWeekDaysCount = 7 };	///< Numbers of day in the week

	// Definition of support functions a global operators for type enum TWeekDay

	/** \brief Conversion and range checking function. Convert \c unsigned value to the TWeekDay
	*  \param[in]	aDayNum		Number of day
	*  \return Return TWeekDay value
	*  \attention Method generate \c std::range_error exception if parameters \p aDayNum is out of numbers of the day
	*/
	TWeekDay CheckRangeWithException(const unsigned aDayNum);

	/** \brief Conversion Day number to the Day name
	*  \param[in]	aWeekDay	Day enumeration
	*  \return Return Day name
	*/
	const char* TWeekStringName(TWeekDay aWeekDay);

	/** \brief Output to the stream operator. (\em serialization)
	*  \param[in]	aOStream	Output stream
	*  \param[in]	aWeekDay	Serialized instantion of TWeekDay
	*  \return Return \c std::ostream with serialized aWeekDay
	*/
	std::ostream& operator<<(std::ostream& aOStream, const TWeekDay& aWeekDay);

	/** \brief Input from the stream operator. (\em deserialization)
	*  \param[in]	aIStream	Input stream
	*  \param[out]	aWeekDay	Place for deserialized instantion of TWeekDay
	*  \return Return rest of \c std::istream
	*  \attention Method generate \c std::range_error exception if stream doesn't contains correct name of the day
	*  \attention Method generate \c std::runtime_error exception if stream isn't in good state
	*/
	std::istream& operator>>(std::istream& aIStream, TWeekDay& aWeekDay);

	
	/** \brief CXItem class (\c TWeekDay variant)
	 *  \details Definition of CXItem class (\c TWeekDay variant). There is defined all common methods and attributes.
	 */
	class CXItem: public CXItemBase
		{				
		const ClassInfo<CXItem> iInstanceInfo;	///< Instance for class info statistics usage
		enum TWeekDay iValue;	///< Encapsulated \c enum TWeekDay value

	public:
	// c'tors
	/** \brief Implicit c'tor
	 *  \details Value attributes is set to \c EMonday. Inherited attributes are initialised by CXItemBase implicit c'tor.
	 */
		CXItem(): iValue(CheckRangeWithException(EMonday))
			{}
			
	/** \brief Conversion c'tor
	 *  \details Pointer attributes are initialised to the \c this value.
   	 *  \param[in]	aValue New TWeekDay value
	 *  \param[in]	aExtraInt	Auxiliary \c int value
	 *  \attention Method generate \c std::range_error exception if parameters \p aValue is out of the \c enum TWeekDay range.
	 *  \note Using of auxiliary \p ExtraInt value is useful for some projects only: multiset[same values counter], priority queue[priority]
	 */
		explicit CXItem(const enum TWeekDay aValue, int aExtraInt = 0): CXItemBase(this, this, aExtraInt), iValue(CheckRangeWithException(aValue))
			{}
	/** \brief Conversion c'tor
   	 *  \param[in]	aValue New TWeekDay value
	 *  \param[in]	aLeft	Pointer to the left linked CXItemBase
	 *  \param[in]	aRight	Pointer to the right linked CXItemBase
	 *  \param[in]	aExtraInt	Auxiliary \c int value
	 *  \attention Method generate \c std::invalid_argument exception if parameters \p aLeft or \p aRight contain \c nullptr value.
	 *  \attention Method generate \c std::range_error exception if parameters \p aValue is out of the \c enum TWeekDay range.
	 *  \note Using of auxiliary \p ExtraInt value is useful for some projects only: multiset[same values counter], priority queue[priority]
	 */
		CXItem(const enum TWeekDay aValue, CXItem *aLeft, CXItem *aRight, int aExtraInt = 0): CXItemBase(aLeft, aRight, aExtraInt), iValue(CheckRangeWithException(aValue))
			{}
			
	/** \brief Copy c'tor
	 *  \details Create new instance by copying only \p iValue parameter. All intrusive attributes (pointers,ExtraInt) are set to the their default values.
	 *  \param[in]	aItem	Original instance for copying
	 */
		CXItem(const CXItem& aItem): CXItemBase(), iValue(aItem.Value())
			{}
			
	/** \brief String conversion c'tor
	 *  \details Create new instance from Value in the string. Pointer attributes are initialised to the \c this value.
	 *  \param[in] aStr Plain C string with string value convertable to the TWeekDay value
	 *  \param[in]	aExtraInt	Auxiliary \c int value
	 *  \note Using of auxiliary \p ExtraInt value is useful for some projects only: multiset[same values counter], priority queue[priority]
	 */
		explicit CXItem(const char* aStr, int aExtraInt = 0): CXItemBase(this, this, aExtraInt), iValue(EMonday)
			{std::istringstream iss(aStr, std::istringstream::in); iss >> iValue;}

	/** \brief String conversion c'tor
	 *  \details Create new instance from Value in the string.
	 *  \param[in] aStr Plain C string with string value convertable to the TWeekDay value
	 *  \param[in]	aLeft	Pointer to the left linked CXItemBase
	 *  \param[in]	aRight	Pointer to the right linked CXItemBase
	 *  \param[in]	aExtraInt	Auxiliary \c int value
	 *  \attention Method generate \c std::invalid_argument exception if parameters \p aLeft or \p aRight contain \c nullptr value.
	 *  \note Using of auxiliary \p ExtraInt value is useful for some projects only: multiset[same values counter], priority queue[priority]
	 */			
		CXItem(const char* aStr, CXItem *aLeft, CXItem *aRight, int aExtraInt = 0): CXItemBase(aLeft, aRight, aExtraInt), iValue(EMonday)
			{std::istringstream iss(aStr, std::istringstream::in); iss >> iValue;}
		
	// d'tor
	/** \brief Virtual d'tor
	 */			
		virtual ~CXItem()
			{iValue = EMonday;}

	// setter/getter
	/** \brief Value setter
	 *  \param[in]	aValue	New Value
	 *  \attention Method generate \c std::range_error exception if parameters \p aValue is out of the \c enum TWeekDay range.
	 */
		void SetValue(const TWeekDay aValue)
			{iValue = CheckRangeWithException(unsigned(aValue));}
			
	/** \brief Value getter
	 *  \return Actual \c bool \p Value
	 */
		TWeekDay Value() const
			{return(iValue);}

	// operators
	/** \brief Complement operator
	 *  \return CXItem instance with complemented attribute Value. All intrusive attributes (pointers,ExtraInt) are set to the their default values.
	 */			
		CXItem operator-() const
			{unsigned tmp = unsigned(ESunday) - unsigned(Value());  return(CXItem(TWeekDay(tmp)));}
			
	/** \brief Assigment operator
	 *  \return CXItem instance with copied attribute Value. All intrusive attributes (pointers,ExtraInt) has previous values.
	 */
		CXItem& operator=(const CXItem& aItem)
			{SetValue(aItem.Value());return(*this);}
			
	/** \brief Comparing by Value operator
	 *  \return Return \c bool result of comparation
	 */			
		bool operator==(const CXItem& aItem) const
			{return(iValue == aItem.Value());}
			
	/** \brief Comparing by Value operator
	 *  \return Return \c bool result of comparation
	 */
		bool operator!=(const CXItem& aItem) const
			{return(iValue != aItem.Value());}
			
	/** \brief Comparing by Value operator
	 *  \return Return \c bool result of comparation
	 */
		bool operator<(const CXItem& aItem) const
			{return(iValue < aItem.Value());}
			
	/** \brief Comparing by Value operator
	 *  \return Return \c bool result of comparation
	 */
		bool operator>(const CXItem& aItem) const
			{return(iValue > aItem.Value());}

	/** \brief Output to the stream operator. (\em serialization)
	 *  \param[in]	aOStream	Output stream
	 *  \param[in]	aItem	Serialized instantion of CXItem
	 *  \return Return \c std::ostream with serialized Value
	 */
		friend std::ostream& operator<<(std::ostream& aOStream, const CXItem& aItem)
			{aOStream << aItem.Value(); return(aOStream);}
				
	/** \brief Input from the stream operator. (\em deserialization)
	 *  \param[in]	aIStream	Input stream
	 *  \param[out]	aItem	Place for deserialized instantion of CXItem
	 *  \return Return rest of \c std::istream
	 */
		friend std::istream& operator>>(std::istream& aIStream, CXItem& aItem)
			{aIStream >> aItem.iValue; return(aIStream);}

#ifdef CXITEM_TEST_VALUES
		// constants for testing CXItem functionality

		/** \brief First test value
		*  \return Return TWeekDay value (EMonday)
		*  \note Useful for automated testing of CXItem functionality
		*/
		static TWeekDay TestValue0()
			{return(EMonday);}

		/** \brief First test string value
		*  \return Return string with TWeekDay value (EMonday)
		*  \note Useful for automated testing of CXItem functionality
		*/
		static const char* TestStringValue0()
			{return("(Monday)");}

		/** \brief Second test value
		*  \return Return TWeekDay value (ETuesday)
		*  \note Useful for automated testing of CXItem functionality
		*/
		static TWeekDay TestValue1()
			{return(ETuesday);}

		/** \brief Second test string value
		*  \return Return string with TWeekDay value (ETuesday)
		*  \note Useful for automated testing of CXItem functionality
		*/
		static const char* TestStringValue1()
			{return("(Tuesday)");}

		/** \brief Random test value
		*  \return Return random TWeekDay value
		*  \note Useful for automated testing of CXItem functionality
		*/
		static TWeekDay TestValueRandom()
			{return(CheckRangeWithException(std::rand() % KTWeekDaysCount));}

		/** \brief Random test string value
		*  \return Return string with random TWeekDay value
		*  \note Useful for automated testing of CXItem functionality
		*/
		static const char* TestStringValueRandom()
			{return(TWeekStringName(TestValueRandom()));}

#endif /* CXITEM_TEST_VALUES */

	// InstanceInfo getters
	/** \brief ID getter
	*  \return Unique instance ID
	*/
		virtual unsigned ID() const override
			{return(iInstanceInfo.ID());}

		}; /* class CXItem */

	} /* namespace CXItem_TWeekDay */

#endif /* __CXITEM_TWEEKDAY_H__ */
