/** \file main.cpp
 *  \brief Main source
 *  \details Simple CXItem example of usage
 *  \author Pety 2014
 *  $Id: main.cpp 1 2014-10-29 15:27:54Z petyovsky $
 */

#include <ctime>
#include <iostream>
#include "CXItem.h"
#include "check.h"

using std::endl;
using std::cout;
using std::cin;
using std::cerr;

int main(int argc, char *argv[])
	{
	std::srand(unsigned(std::time(nullptr))); // Initialize random generator by actual time

	cout << "Pocet parametru: " << argc << endl;
	for(int i = 0; i < argc; i++)
		cout << "Parametr #" << i << ": " << argv[i] << endl;
	
	cout << endl << "Nyni existuje " << ClassInfo<CXItem>::Living() << " instanci tridy: " << DM(typeid(CXItem).name()) << endl;
	cout << "Velikost jedne instance tridy " << DM(typeid(CXItem).name()) << " je: " << sizeof(CXItem) << " bajtu." << endl;

	try
		{
	// Test c'tor implicitni
		CXItem_bool::CXItem temp_instance1;
		CXItem_TWeekDay::CXItem temp_instance2;

		CXItem a;
		cout << "Objekt 'a' je " << a.ID() << "-tou instanci tridy: " << DM(typeid(CXItem).name()) << endl;
		cout << "Nyni existuje " << ClassInfo<CXItem>::Living() << " instanci tridy: " << DM(typeid(CXItem).name()) << endl;
		cout << "V prubehu programu zatim vzniklo celkem " << ClassInfo<CXItem>::Total() << " instanci tridy: " << DM(typeid(CXItem).name()) << endl;

	// Test c'tor konverzni
		CXItem b(CXItem::TestValue0());
		CXItem c(CXItem::TestValue1());

	// Test c'tor copy
		CXItem d = a;
		CXItem e(a);

	// Test c'tor se dvema parametry
		CXItem f(CXItem::TestValue0(), &d, &e);
		f.SetLeft(&f, &d);
		f.SetRight(&f, &e);

	// Test c'tor z retezce
		const char *str(CXItem::TestStringValue1());
		cout << "C'tor instance CXItem z C retezce: \"" << str << "\"." << endl;
		CXItem g(CXItem::TestStringValue0());
		CXItem h(str);
		cout << " V instanci je hodnota: " << h << endl;

	// Test CXItem::operator<<
		cout << "CXItem::operator<<" << endl;
		cout << ' ' << a << ',' << b << ',' << c << ','<< d << ',' << e << ',' << f << ',' << g << ',' << h << endl;

	// Test CXItem::operator>>
		cout << "CXItem::operator>>" << endl;
		cout << " Test vlozeni " << DM(typeid(CXItem).name()) << " nahodne hodnoty\n";
		const char* teststring = CXItem::TestStringValueRandom();
		cout << " Vkladam hodnotu: '" << teststring << '\'' << endl;
		std::istringstream test_cin(teststring, std::istringstream::in);
		test_cin >> d;
		cout << " V instanci je hodnota: " << d << endl;

	// Test setter CXItem::SetValue
		cout << "CXItem::SetValue" << endl;
		b.SetValue(CXItem::TestValue0());

	// Test getter CXItem::Value
		cout << "CXItem::Value" << endl;
		cout << " Value=" << a.Value() << endl;

	// Test setter/getter CXItem::ExtraInt
	// Pouzitelne pouze pro nektere projekty, napr. multimnozina, prioritni fronta. V ostatnich projektech nebude vyuzito.
		int priority = 1;
		a.SetExtraInt(priority);
		priority = a.ExtraInt();
		int pocetStejnychPrvkuMultimnoziny = 1;
		a.SetExtraInt(pocetStejnychPrvkuMultimnoziny);
		pocetStejnychPrvkuMultimnoziny = a.ExtraInt();

	// Test CXItem::operator-
		cout << "CXItem::operator-" << endl;
		cout << ' ' << c << ',';
		cout << -c << ',';
		cout << c << endl;

    // Test CXItem::operator=
		c = a;

	// Test CXItem::operator==
		cout << "CXItem::operator==" << endl;
		cout << " Hodnota v objektu 'a' je ";
		if(a == d)
			cout << "stejna jako hodnota";
		else
			cout << "ruzna od hodnoty";
		cout << " v objektu 'd'" << endl;

	// Test CXItem::operator!=
		cout << "CXItem::operator!=" << endl;
		cout << " Hodnota v objektu 'a' je ";
		if(a != d)
			cout << "ruzna od hodnoty";
		else
			cout << "stejna jako hodnota";
		cout << " v objektu 'd'" << endl;

	// Test CXItem::operator>
		cout << "CXItem::operator>" << endl;
		cout << " Hodnota v objektu 'a' ";
		if(a > d)
			cout << "je";
		else
			cout << "neni";
		cout << " vetsi nez hodnota v objektu 'd'" << endl;

	// Test CXItem::operator<
		cout << "CXItem::operator<" << endl;
		cout << " Hodnota v objektu 'a' ";
		if(a < d)
			cout << "je";
		else
			cout << "neni";
		cout << " mensi nez hodnota v objektu 'd'" << endl;

		cout << "Nyni existuje " << ClassInfo<CXItem>::Living() << " instanci tridy: " << DM(typeid(CXItem).name()) << endl;
			
	// Test getter CXItem::Left()
		cout << "CXItem::Left" << endl;
		cout << " Hodnota ukazatele Left v objektu 'a' " << a.Left(&a) << endl;
		cout << "  (Objekt 'a' je na adrese: " << &a << ')' << endl;

	// Test getter CXItem::Right()
		cout << "CXItem::Right" << endl;
		cout << " Hodnota ukazatele Right v objektu 'a' " << a.Right(&a) << endl;
		cout << "  (Objekt 'a' je na adrese: " << &a << ')' << endl;

	// Test setter CXItem::SetLeftRight
		cout << "CXItem::SetLeftRight" << endl;
		cout << " Propojeni obousmerne vazaneho linearniho seznamu objektu 'a' - 'h'" << endl;
		a.SetLeftRight(&a, &b);
		b.SetLeftRight(&a, &c);
		c.SetLeftRight(&b, &d);
		d.SetLeftRight(&c, &e);
		e.SetLeftRight(&d, &f);
		f.SetLeftRight(&e, &g);
		g.SetLeftRight(&f, &h);
		h.SetLeftRight(&g, &h);

	// Test getter CXItem::Next()
		cout << "CXItem::Left" << endl;
		cout << " Hodnota ukazatele Left v objektu 'a' " << a.Left(&b) << endl;
		cout << "  (Objekt 'a' je na adrese: " << &a << ')' << endl;
		cout << "CXItem::Right" << endl;
		cout << " Hodnota ukazatele Right v objektu 'a' " << a.Right(&a) << endl;
		cout << "  (Objekt 'b' je na adrese: " << &b << ')' << endl;

	// Test nemoznosti odkazovat na NULL/nullptr
		//a.SetLeft(nullptr, &a);
		//a.SetRight(nullptr, &b);

	// Vytisknuti seznamu instanci tridy CXItem
		cout << "Vytisknuti seznamu instanci tridy: " << DM(typeid(CXItem).name()) << endl;
		const CXItemBase *ptrPrev = &a;
		const CXItemBase *ptrActual = &a;
		const CXItemBase *ptrNext = nullptr;
		do
			{
			ptrNext = ptrActual->Right(ptrPrev);

			cout << '\t' << ptrActual << ": " << DM(typeid(*ptrActual).name()) << "#" << ptrActual->ID();
			cout << " <" << ptrActual->Left(ptrNext) << ',' << dynamic_cast<const CXItem*>(ptrActual)->Value() << ',' << ptrActual->Right(ptrPrev) << '>' << endl;

			ptrPrev = ptrActual;
			ptrActual = ptrNext;			
			}
		while(ptrPrev != ptrActual);

	// Rozpojeni seznamu instanci tridy CXItem
		cout << "Rozpojeni seznamu instanci tridy: " << DM(typeid(CXItem).name()) << endl;
		do
			{
			ptrPrev = ptrActual->Left(ptrNext);

			ptrActual->SetLeft(ptrActual, ptrPrev);
			ptrActual->SetRight(ptrActual, ptrNext);

			cout << '\t' << ptrActual << ": " << DM(typeid(*ptrActual).name()) << "#" << ptrActual->ID();
			cout << " <" << ptrActual->Left(ptrActual) << ',' << dynamic_cast<const CXItem*>(ptrActual)->Value() << ',' << ptrActual->Right(ptrActual) << '>' << endl;

			ptrNext = ptrActual;
			ptrActual = ptrPrev;			
			}
		while(ptrNext != ptrActual);

		} /* try */
	
	catch(std::range_error &e)
		{
		cerr << "std::range_error: " << e.what() << "!!!\n\a" << endl;
		}
	catch(std::runtime_error &e)
		{
		cerr << "std::runtime_error: " << e.what() << "!!!\n\a" << endl;
		}
	catch(std::invalid_argument &e)
		{
		cerr << "std::invalid_argument: " << e.what() << "!!!\n\a" << endl;
		}

// Doplnkove testy
#ifdef SUPPLEMENT_TESTS_TWEEKDAY
	try 
		{
		unsigned x = 0;
		CXItem a;
		cout << "CXItem::operator<<" << endl;
		cout << " Zadej schvalne (kvuli testovani) cislo vetsi nez (0-6) jako hodnotu dne: ";
		cin >> x;
		a.SetValue(TWeekDay(x));
		cout << " Zadal jsi hodnotu: " << a << endl;

		cout << " Zadej schvalne spatne jmeno dne(napr. (Wonday)): ";
		cin >> a;
		cout << " Zadal jsi hodnotu: " << a << endl;
		}
	catch(std::range_error &e)
		{
		cerr << "std::range_error: " << e.what() << "!!!\n\a" << endl;
		}
	catch(std::runtime_error &e)
		{
		cerr << "std::runtime_error: " << e.what() << "!!!\n\a" << endl;
		}
#endif
	cout << endl << "Nyni existuje " << ClassInfo<CXItem>::Living() << " instanci tridy: " << DM(typeid(CXItem).name()) << endl;
	cout << "V prubehu programu vzniklo celkem " << ClassInfo<CXItem>::Total() << " instanci tridy: " << DM(typeid(CXItem).name()) << endl;
	cout << "V prubehu programu vzniklo celkem " << ClassInfo<CXItemBase>::Total() << " instanci tridy: " << DM(typeid(CXItemBase).name()) << endl;
	
	cout << endl << "V prubehu programu vzniklo celkem " << ClassInfo<CXItem_bool::CXItem>::Total() << " instanci tridy: " << DM(typeid(CXItem_bool::CXItem).name()) << endl;
	cout << "V prubehu programu vzniklo celkem " << ClassInfo<CXItem_TWeekDay::CXItem>::Total() << " instanci tridy: " << DM(typeid(CXItem_TWeekDay::CXItem).name()) << endl;
	return(0);
	}
