//
//  Komplex.h
//  Komplex
//
//  Modified by Petr Petyovský on 4/3/13.
// $Id: Komplex.h 83 2013-11-04 12:28:44Z petyovsky $

//======= Komplex.h - hlavička třídy ============
// trasujte a divejte se kudyma to chodi, tj. zobrazte *this, ...
// objekty muzete rozlisit pomoci indexu

#ifndef __KOMPLEX_H__
#define __KOMPLEX_H__

#include <cmath>
#include <iostream>



struct Komplex
	{
private:
	double iRe,iIm;
	int iIndex;

public:

	enum TKomplexType {ESlozky, EUhel};

	static int iPoradi;
	static int iAktivnich;

	//c'tors & d'tors
	Komplex()
		{iRe = iIm = 0; iIndex = iPoradi; iPoradi++; iAktivnich++;}
	
   inline Komplex(double aVal1, double aVal2 = 0, TKomplexType aKType = ESlozky);
		
	
	Komplex(const char *txt);
	
	inline Komplex(const Komplex &p);
	
	~Komplex()
		{iAktivnich--;}
	
	
	// metody
	void PriradSoucet(Komplex const &aVal1, Komplex const &aVal2)
		{iRe = aVal1.iRe + aVal2.iRe; iIm = aVal1.iIm + aVal2.iIm;}
	
	Komplex Soucet(const Komplex &p) const
		{return Komplex(iRe + p.iRe, iIm + p.iIm);}
	
	Komplex& Prirad(Komplex const &p)
		{iRe = p.iRe;iIm = p.iIm; return *this;}
	
	double Amplituda() const
		{return sqrt(AmpSquare());}
	
	double AmpSquare() const
		{return iRe * iRe + iIm * iIm;}
	
	bool JeMensi(Komplex const &p) const
		{return AmpSquare() < p.AmpSquare();}
		
	bool JeVetsi(Komplex const &p) const
		{return AmpSquare() > p.AmpSquare();}
	
	
	// operatory
	Komplex& operator+ ()
		// unární +, může vrátit sám sebe, vrácený prvek je totožný s prvkem, který to vyvolal
		{return *this;}
	
	Komplex operator- () const
		// unární -, musí vrátit jiný prvek než je sám (ten konstruktor v returnu je dost drastický)
		{return Komplex(-iRe,-iIm);}
	
	Komplex & operator++()
		// nejdřív přičte a pak vrátí, takže může vrátit sám sebe (pro komplex patrně nesmysl)
		{iRe++; iIm++; return *this;}
	
	Komplex operator++(int)
		//vrací původní prvek, takže musí vytvořit jiný pro vrácení (pro komplex patrně nesmysl)
		{return Komplex(iRe++, iIm++);}
	
	Komplex& operator= (Komplex const &p)
		// bez const v hlavičce se neprelozi nektera prirazeni, implementováno i zřetězení
		{iRe = p.iRe; iIm = p.iIm; return *this;}
	
	Komplex& operator+=(const Komplex &p)
		// návratový prvek je stejný jako ten, který to vyvolal, takže se dá vrátit sám
		{iRe += p.iRe; iIm += p.iIm; return *this;}
	
	bool operator==(const Komplex &p) const
		{
		if( (iRe == p.iRe) && (iIm == p.iIm) )
			return true;
		return false;
		}

	bool operator!=(const Komplex &p) const
		{
		if( (iRe != p.iRe) || (iIm != p.iIm) )
			return true;
		return false;
		}

	bool operator> (const Komplex &p) const
		// může být definováno i jinak
		{
		if(AmpSquare() > p.AmpSquare())
			return true;
		return false;
		}
	
	bool operator>=(const Komplex &p) const
		{return(AmpSquare() >= p.AmpSquare());}
	
	Komplex operator~ () const
		//komplexne sdruzeny / kdyz je volani bez parametru, musi byt hlavicka bez parametru
		// bylo by dobré mít takové operátory dva jeden, který by změnil sám prvek
		// a druhý, který by prvek neměnil
		{return Komplex(iRe, -iIm);}
	
	Komplex& operator* ()
		// a tady je ten operátor
		// co mění prvek. Problém je, že je to nestandardní pro tento operátor
		// a zároveň se mohou plést. Takže bezpečnější je nechat jen ten první
		{iIm *= -1; return *this;}
	
	Komplex operator+ (const Komplex &p) const
		{return Komplex(iRe + p.iRe, iIm + p.iIm);}
	
	Komplex operator+ (double f) const
		{return Komplex(iRe + f, iIm);}

	Komplex operator- (const Komplex &p) const
		{return Komplex(iRe - p.iRe, iIm - p.iIm);}
	
	Komplex operator- (double f) const
		{return Komplex(iRe - f, iIm);}

	Komplex operator* (Komplex const &p) const
		{return Komplex(iRe * p.iRe - iIm * p.iIm, iRe * p.iIm + iIm * p.iRe);}
	
	Komplex& operator*= (Komplex const &p)
		// zde je nutno použít pomocné proměnné, protože
		// je nutné použít v obou přiřazeních obě proměnné
		// ale je to špatně v případě, že použijeme pro a *= a;, potom první přiřazení změní
		// i hodnotu p.Re a tím nakopne výpočet druhého parametru (! i když je konst !)
		// {double pRe=Re,pIm=Im,oRe=p.Re; Re=pRe*p.Re-Im*p.Im;Im=pRe*p.Im+pIm*oRe;return *this;}
		// verze ve ktere přepsání Re složky již nevadí
		{
		double pRe = iRe, pIm = iIm;
		iRe = pRe * p.iRe - iIm * p.iIm;
		iIm = pRe * p.iIm + pIm * p.iRe;
		return *this;
		}
	
	friend Komplex operator+ (double f, const Komplex &p);
	//není nutné pokud nejsou privátní proměnné
	
	friend Komplex operator- (double f, const Komplex &p);
	//není nutné pokud nejsou privátní proměnné

	operator double() const
		{return Amplituda();}
	
	friend std::ostream& operator<< (std::ostream &aStream, const Komplex& aCplx)
		{
		aStream << '(' << aCplx.iRe;
		
		if(aCplx.iIm >= 0)
			aStream	<< '+';
		
		 aStream << aCplx.iIm << "_i)";
		return(aStream);
		}
	
	}; /* struct Komplex */

	inline Komplex::Komplex(double aVal1, double aVal2, TKomplexType aKType)
		{
		if(aKType == EUhel)
			{
			iRe = aVal1 * cos(aVal2);
			iIm = aVal1 * sin(aVal2);
			}
		else
			{
			iRe = aVal1;
			iIm = aVal2;
			}
		iIndex = iPoradi;
		iPoradi++;
		iAktivnich++;
		}
	
	inline Komplex::Komplex(const Komplex &aVal)
		{
		iRe = aVal.iRe;
		iIm = aVal.iIm;
		iIndex = iPoradi;
		iPoradi++;
		iAktivnich++;
		}


#endif /* __KOMPLEX_H__ */
