#include <windows.h>
#include "grafmain.h"

LRESULT CALLBACK WndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
     static int  cxClient, cyClient;
	 HDC         hdc;
     PAINTSTRUCT ps;
	 RECT rect;
     
     switch (message)
     {
     case WM_SIZE:
          cxClient = LOWORD (lParam) ;
          cyClient = HIWORD (lParam) ;
          return(0L);
          
     case WM_PAINT:
          hdc = BeginPaint (hwnd, &ps) ;
		  GetClientRect (hwnd, &rect) ;
 		  DrawGraf(hdc,&rect);
		  EndPaint(hwnd, &ps) ;
          return(0L);

     case WM_LBUTTONUP:    
          RandData(data,DATASIZE);
		  GetClientRect (hwnd, &rect);
		  InvalidateRect(hwnd,&rect,TRUE); // handle to window,rectangle, erase state
		  return(0L);

     case WM_RBUTTONUP:    
     case WM_DESTROY:
          PostQuitMessage(0);
          return 0 ;
     }
     return( DefWindowProc(hwnd, message, wParam, lParam));
} /* WndProc() */


int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow)
{
     static TCHAR szAppName[] = TEXT ("GrafyDemo") ;
     HWND         hwnd ;
     MSG          msg ;
     WNDCLASS     wndclass ;
     
     wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
     wndclass.lpfnWndProc   = WndProc ;
     wndclass.cbClsExtra    = 0 ;
     wndclass.cbWndExtra    = 0 ;
     wndclass.hInstance     = hInstance ;
     wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
     wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
     wndclass.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH) ;
     wndclass.lpszMenuName  = NULL ;
     wndclass.lpszClassName = szAppName ;
     
     if (!RegisterClass (&wndclass))
     {
          MessageBox (NULL, TEXT ("Program vyzaduje Windows NT!"), 
                      szAppName, MB_ICONERROR) ;
          return 0 ;
     }
     
	 RandData(data, DATASIZE); //Vygeneruj nase pole vzorku
     hwnd = CreateWindow (szAppName, TEXT ("Grafy (demonstrace WinAPI grafiky)"),
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;
     
     ShowWindow (hwnd, iCmdShow) ;
     UpdateWindow (hwnd) ;
     
     while (GetMessage (&msg, NULL, 0, 0))
     {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
     }
     return msg.wParam ;
} /* WinMain() */

