#include <windows.h>

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM) ;

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow)
{
     static TCHAR szAppName[] = TEXT ("LineDemo") ;
     HWND         hwnd ;
     MSG          msg ;
     WNDCLASS     wndclass ;
     
     wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
     wndclass.lpfnWndProc   = WndProc ;
     wndclass.cbClsExtra    = 0 ;
     wndclass.cbWndExtra    = 0 ;
     wndclass.hInstance     = hInstance ;
     wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
     wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
     wndclass.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH) ;
     wndclass.lpszMenuName  = NULL ;
     wndclass.lpszClassName = szAppName ;
     
     if (!RegisterClass (&wndclass))
     {
          MessageBox (NULL, TEXT ("Program vyaduje Windows NT!"), 
                      szAppName, MB_ICONERROR) ;
          return 0 ;
     }
     
     hwnd = CreateWindow (szAppName, TEXT ("Demonstrace ar"),
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;
     
     ShowWindow (hwnd, iCmdShow) ;
     UpdateWindow (hwnd) ;
     
     while (GetMessage (&msg, NULL, 0, 0))
     {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
     }
     return msg.wParam ;
}

LRESULT CALLBACK WndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
     static int  cxClient, cyClient ;
	 static int  flag =0;
	 static int  mousepressed=0;
 	 static int  posx,posy;
	 static int  posxtmp,posytmp;
	 HDC         hdc ;
     PAINTSTRUCT ps ;
	 RECT rect;
     HPEN hpen, hpenOld;
	 	 
     
     switch (message)
     {
     case WM_SIZE:
          cxClient = LOWORD (lParam) ;
          cyClient = HIWORD (lParam) ;
          return(0L) ;
          
     case WM_PAINT:
          hdc = BeginPaint (hwnd, &ps) ;

          Rectangle (hdc,     cxClient / 8,     cyClient / 8,
                          7 * cxClient / 8, 7 * cyClient / 8) ;
          
          MoveToEx  (hdc,        0,        0, NULL) ;
          LineTo    (hdc, cxClient, cyClient) ;
          
          MoveToEx  (hdc,        0, cyClient, NULL) ;
          LineTo    (hdc, cxClient,        0) ;
          
          Ellipse   (hdc,     cxClient / 8,     cyClient / 8,
                          7 * cxClient / 8, 7 * cyClient / 8) ;
          
          RoundRect (hdc,     cxClient / 4,     cyClient / 4,
                          3 * cxClient / 4, 3 * cyClient / 4,
                              cxClient / 4,     cyClient / 4) ;

		  GetClientRect (hwnd, &rect) ; 
		  DrawText (hdc, TEXT ("Dti Killer je tady!!!"), -1, &rect,
                    DT_SINGLELINE | DT_CENTER | DT_VCENTER) ;

		  SetPixel(hdc, rect.left + 10, rect.top + 10, RGB(0x55,0xFF,0x55));
          if(flag)
		  {
		   SetPixel(hdc, rect.left + 20+flag, rect.top + 20+flag, RGB(0xFF,0x01,0x55)); 
		   DrawText (hdc, TEXT ("JOOOOOOOOOOOO!!!"), -1, &rect,
                    DT_SINGLELINE | DT_CENTER | DT_VCENTER) ;

		  }
		  EndPaint (hwnd, &ps) ;
          return(0L);

     case WM_LBUTTONDOWN:
   		  flag++;
		  GetClientRect (hwnd, &rect);
		  InvalidateRect(hwnd,&rect,FALSE); // handle to window,rectangle, erase state
          return(0L);

     case WM_RBUTTONDOWN:  
		  mousepressed=TRUE;
		  posx= posxtmp= LOWORD(lParam); 
		  posy= posytmp= HIWORD(lParam); 
          return(0L);

	 case WM_RBUTTONUP: 
		  if (mousepressed)
		  {
		   hdc = GetDC(hwnd); 
		   MoveToEx(hdc, posx, posy, NULL); 
		   LineTo(hdc, LOWORD(lParam), HIWORD(lParam)); 
		   ReleaseDC(hwnd, hdc); 
		  }
		  mousepressed=0;
		  return(0L);

  	 case WM_MOUSEMOVE: 
		  if (mousepressed)
		  {
		   hdc = GetDC(hwnd); 
		   MoveToEx(hdc, posxtmp, posytmp, NULL); 
		   hpen = CreatePen(PS_SOLID, 1, RGB(0, 255, 0));
           hpenOld = SelectObject(hdc, hpen);
  		   LineTo(hdc, posxtmp=LOWORD(lParam), posytmp=HIWORD(lParam)); 
		   
           SelectObject(hdc, hpenOld);
           DeleteObject(hpen);
    
		   ReleaseDC(hwnd, hdc); 
		  }
		  return(0L);

     case WM_DESTROY:
          PostQuitMessage (0) ;
          return(0L) ;
     }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
}

 
 