﻿


/** 

\mainpage Seznámení s prostředím Doxygen v návaznosti na VC++

\n

|  Demo pro CPP| 2012 |
|-------|---|
|autor1| Richter M | 
| | richter @ feec|
|autor2| Petyovsky P |
| | petyovsky @ feec|
|název |Ukázka doxygen|
|datum zadání| jaro |
|datum odevzdání | o rok později |

\n\n


[Popis nejčastěji používaných zkratek] (\ref sem1)

\page  \brief Popis prostředí



## Co to je a k čemu to slouží.

Je to parser, který prochází soubory patřící k projektu. V nich hledá speciálně označené komentáře (svoje značky) a na jejich základě vytváří dokumentaci. Díky své "inteligenci" dokáže sledovat i vazby mezi typy, funkcemi a proměnnými a zobrazovat je.
Výsledkem je přehledná dokumentace, která vyžaduje "pouze" to, že při psaní programu je nutné ho poctivě komentovat a komentáře označit odpovídajícími značkami.
Doxygen podporuje různé jazyky, mezi nimi C a C++. 

##Jak začít?

###Instalace  
Je nutné nainstalovat program doxygen a případně i pomocné soubory (grafické znázornění UML, podpora pro (La)Tex, ...). 
Program je možné stáhnout z adresy http://www.doxygen.org/download.html. Je zde binární instalace i zdrojové kódy, které je možné si přeložit sami.

Pokud je potřeba vytvářet "hezčí" (složitejší) grafy závislostí, je nutné nainstalovat program Graphviz (http://www.graphviz.org/) a v konfiguračním souboru nastavit _HAVE_DOT_ na _YES_. 
Původně jednoduché grafy závislostí (je, má) jsou teď podstatně detailnější.

###Vytvoření konfiguračního souboru
- ručně, 
- vygenerováním implicitního a jeho úpravou,
- pomocí wizardu. 

K ručnímu napsání je třeba dobré znalosti (a asi se bude vycházet ze staršího souboru). Vygenerování konfiguračního souboru je možné příkazem
_doxygen -g JmenoSouboru_. Konfigurační soubor v sobě obsahuje kromě nastavení i komentáře k položkám. Je možné použít i vygenerování stručné formy bez komentářů, pouze s nastaveními,
příkazem _doxygen -s - g JmenoSouboru_. Tento soubor je možné upravovat (měnit nastavení položek). Poslední možností je spuštění GUI wizardu a nastavování položek zde "klikáním".


###Nastavení konfiguračního souboru 
Při použití českých textů, musí být soubory (projektový, cpp i h) uloženy v UTF-8, nebo musí být položka DOXYFILE_ENCODING změněna na použité kódování. Ukládání v UTF je možné ve VisualC++ provést pomocí položky SaveAs/save(rozbalit šipkou)/SaveWithEncoding/Encoding=UnicodeUTF-8WithSignature. Do položky PROJECT_NAME zadejte jméno svého projektu. pokud nemáte nainstalován Latex, vypněte ho "přepnutím" položky GENERATE_LATEX na NO.
\note I když je možné ve většině prostředí pracovat s českými znaky, přináší to problémy. Problémem může být různé kódování češtiny, které může při přenosu na jinou platformu nebo 
překladač způsobit problémy (mluvíme zde samozřejmě o komentářích, čeština v názvech proměnných není povolena). Druhým a hlavním problémem je schopnost externích vývojových prostředků (plug-iny, řádkové příkazy pro (před)zpracování, formátovací a testovací programy ...) pracovat s českými znaky v různých kódováních. Zdrojové texty (*.cpp, *.h), které se účastní překladu by
tedy měly být psány bez diakritiky.

OUTPUT_LANGUAGE (v případě dokumentace v češtině) nastavit na Czech (nic nedělá???)
Projekt prochází soubory v aktuálním adresáři, případné další adresáře je možné přidat v konfiguračním souboru.
V případě rozsáhlejšího projektu je nutné nastavit do parametru INPUT ostatní adresáře, případně vyjmenovat soubory, které se mají přidat. Pokud je potřeba přidat i soubory s netradiční koncovkou, tak ta se nastaví do FILE_PATTERNS.
V případě, že projekt je pouze v podadresářích, lze nastavit RECURSIVE na YES.
Pomocí volby OUTPUT_DIRECTORY lze určit kam se bude ukládat, jinak si vytvoří vlastní podadresář.
Pro zařazení privátních členů tříd je nutné nastavit EXTRACT_PRIVATE na YES.

Použití konfiguračního souboru - v adresáři, kde jsou zdrojové a hlavičkové soubory, které je nutné zpracovat spustíme doxygen JmenoSouboru (je možné mít i více konfiguračních souborů k jednomu projektu). 
Je vytvořen adresář html (tex ...) a v něm "první" stránka je index.html - otevřete ji ve www prohlížeči.
Lze dodat i hlavičku, patičku, formát: doxygen -w html header.html footer.html customdoxygen.css.

##Obecná pravidla

Text se neformátuje podle konce řádků. Nový odstavec se vytvoří pomocí volného řádku (dva "entery" po sobě).
Text se někdy používá i na několika místech, nebo je "někam" přesunut, proto je vhodné začínat velkým písmenem a končit tečkou.
Dokumentace je prováděna pro komentované části. Při "tvorbě" dokumentace jsou zobrazovány zprávy o částech, které nejsou komentované.
Abychom mohli okomentovat něco (například třídu, resp. proměnnou ve třídě) bývá často podmínka, že musíme okomentovat i "nadřazenou" sekci (zde soubor, resp. třídu).
Na výsledný text mohou mít vliv mezery, tabulátory, volné řádky, chybně napsané řídící znaky. Proto je vhodné kontrolovat výsledný dokument, abychom případnou chybu hledali v co nejmenším okruhu nových popisů (Jelikož parser z textu vybere bloky a z nich pak seskládá (takřka náhodně) výsledný text, není vždy z "rosypaného" výsledku jasné, kde je chyba v originále).

##Jak komentovat

Vychází se z komentářů jazyka C/C++, které jsou rozšířeny o znak pro doxygen - /** ... * / pro víceřádkový a /// pro řádkový komentář (lze použít i alternativy /*! * / a //!).
Existuje krátký (brief) komentář a dlouhý (detailed) komentář. Ačkoli jich může ke každému tématu být několik, není to dobré používat, protože jejich výsledné pořadí není definované.
Krátký komentáře se zobrazuje v přehledech (například u seznamu souborů, proměnných, metod ...). Detailní se zobrazí u popisu při výběru konkrétní položky (soubor, funkce, proměnná ...).
Komentář je vždy u položky, kterou hodláme popsat a vypadá například takto (řídící slova jsou uvozena @ nebo \)
/* * \ brief orientační popis
/* * @ brief orientační popis




Poznámky k další práci - ToDo
Poznámky je možné vkládat kamkoli do textu, ze kterého se tvoří dokumentace. Poznámka je zobrazena v souboru, ke kterému patří a zároveň také na stránce "TODO List".



\todo Popsat instalaci

\todo jak nainstalovat češtinu?

\todo tvorba stránek



*/