#ifndef __CLASSINFO_H__
#define __CLASSINFO_H__
/** \file ClassInfo.h
 *  \brief ClassInfo class header
 *  \details File contain ClassInfo definition.
 *  \warning Don't modify this file
 *  \author Pety 2014
 *  $Id: ClassInfo.h 1 2014-10-29 15:27:54Z petyovsky $
 */

/** \brief ClassInfo class template
 *  \tparam	T	The class name for which want to keep statistical information
 *  \details Definition of ClassInfo class template. There is defined all common methods and attributes.
 */
template <typename T>
	class ClassInfo
		{
		const unsigned iID;			///< Constant value for simple runtime instance identification and debuging
		static unsigned iTotalCounter;	///< Summary count of all created instances
		static int iLivingCounter;	///< Counter of actually existing instances
#if (__cplusplus >= 201103L) || (_MSC_VER >= 1600)
		friend T;		///< Set Template argument class as friend. So no one (only class) have access to the private methods of ClassInfo instances. C++11 feature.
#else
	public:
#endif
	//c'tors
#define CLASSINFO_IMPLICIT_CTOR_BODY :iID(iTotalCounter++) {iLivingCounter++;}
#if (__cplusplus >= 201103L) || (_MSC_VER >= 1800)
	#define CLASSINFO_IMPLICIT_CTOR_BODY_DELEGATED :ClassInfo() {}
#else
	#define CLASSINFO_IMPLICIT_CTOR_BODY_DELEGATED CLASSINFO_IMPLICIT_CTOR_BODY
#endif
		
	/** \brief Implicit c'tor
	 *  \details Initialise iID and increment counters.
	 */
		ClassInfo() CLASSINFO_IMPLICIT_CTOR_BODY

	/** \brief Copy c'tor
	 *  \details Initialise iID and increment counters.
	 */
		ClassInfo(const ClassInfo &) CLASSINFO_IMPLICIT_CTOR_BODY_DELEGATED
		
	//d'tor
	/** \brief d'tor
	 *  \details Decrement Living instance counter only.
	 */
		~ClassInfo()
			{iLivingCounter--;}

	/** \brief Assigment operator
	 *  \return Only return self.
	 */
		ClassInfo& operator=(const ClassInfo &)
			{return(*this);}
		
#if 0
	// Move semantics test (still doesn't work correctly in VS2013)
	/** \brief Move c'tor!
	 *  \details Initialise iID and increment counters.
	 */
		ClassInfo(ClassInfo &&) CLASSINFO_IMPLICIT_CTOR_BODY_DELEGATED
		
	/** \brief Move operator!
	 *  \return Only return self.
	 */
		ClassInfo& operator=(ClassInfo &&)
			{return(*this);}
#endif

	/** \brief ID getter
	 *  \return Unique instance ID
	 */
		unsigned ID() const
			{return(iID);}

#if (__cplusplus >= 201103L) || (_MSC_VER >= 1600)
	public:
#endif
	// counters getters
	/** \brief Getter for actual count of all created instances
	 *  \return Actual count of all created instances
	 */
		static unsigned Total()
			{return(iTotalCounter);}
		
	/** \brief Getter for count of actually existing instances
	 *  \return Count of actually existing instances
	 */
		static int Living()
			{return(iLivingCounter);}
		
		}; /* class ClassInfo */

template <typename T>
	unsigned ClassInfo<T>::iTotalCounter = 0;

template <typename T>
	int ClassInfo<T>::iLivingCounter = 0;

#endif /* __CLASSINFO_H__ */
